/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.impl;

import com.mulesoft.mule.module.datamapper.api.FutureCallback;
import com.mulesoft.mule.module.datamapper.api.GraphExecutor;
import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.OutputArgumentHandler;
import com.mulesoft.mule.module.datamapper.api.Status;
import com.mulesoft.mule.module.datamapper.api.TransformationEngine;
import com.mulesoft.mule.module.datamapper.api.TransformationResult;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperExecutionException;
import com.mulesoft.mule.module.datamapper.clover.MappingFormat;
import com.mulesoft.mule.module.datamapper.util.BlockingPipeList;
import java.io.Closeable;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultGraphExecutor<T>
implements GraphExecutor {
    public static final String MULE_INPUT_PAYLOAD_KEY = "inputPayload";
    public static final String MULE_OUTPUT_PAYLOAD_KEY = "outputPayload";
    private static Log logger = LogFactory.getLog(DefaultGraphExecutor.class);
    private GraphProvider<T> graphProvider;
    private TransformationEngine<T> engine;
    private GraphProvider<T> asyncGraphProvider;

    public static <T> DefaultGraphExecutor<T> createGraphExecutor(GraphProvider<T> graphProvider, GraphProvider<T> asyncGraphProvider, TransformationEngine<T> engine) {
        return new DefaultGraphExecutor<T>(graphProvider, asyncGraphProvider, engine);
    }

    private DefaultGraphExecutor(GraphProvider<T> graphProvider, GraphProvider<T> asyncGraphProvider, TransformationEngine<T> engine) {
        Validate.notNull(graphProvider);
        this.asyncGraphProvider = asyncGraphProvider;
        this.graphProvider = graphProvider;
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransformationResult execute(Object input, Map<String, Object> inputArguments) throws DataMapperExecutionException {
        T currentGraph = this.graphProvider.takeGraph();
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(MULE_INPUT_PAYLOAD_KEY, input);
        arguments.put(MULE_OUTPUT_PAYLOAD_KEY, null);
        if (inputArguments != null) {
            arguments.putAll(inputArguments);
        }
        TransformationResult result = null;
        try {
            result = this.getEngine().execute(currentGraph, arguments);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Graph executed successfully");
            }
            if (result.getStatus() != Status.OK) {
                throw new DataMapperExecutionException("Error executing graph: " + result.getMessage(), result.getCauseException());
            }
            TransformationResult transformationResult = result;
            return transformationResult;
        }
        finally {
            if (result == null || result.getStatus() != Status.OK) {
                this.graphProvider.invalidateObject(currentGraph);
            } else {
                this.graphProvider.releaseGraph(currentGraph);
            }
        }
    }

    private Iterator<?> executeObjectStreaming(int pipeSize, T currentGraph, Map<String, Object> arguments, OutputArgumentHandler outputArgumentHandler) throws DataMapperExecutionException {
        BlockingPipeList outputSource = new BlockingPipeList(pipeSize);
        arguments.put(MULE_OUTPUT_PAYLOAD_KEY, outputSource);
        try {
            this.getEngine().executeLater(currentGraph, arguments, new GraphExecutionCallback(currentGraph, outputSource, outputArgumentHandler));
            return outputSource.iterator();
        }
        catch (DataMapperExecutionException e) {
            this.asyncGraphProvider.invalidateObject(currentGraph);
            outputSource.close();
            logger.error((Object)"Exception while executing transformation graph", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.asyncGraphProvider.invalidateObject(currentGraph);
            logger.error((Object)"Exception while initializing the graph", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object executeStreaming(Object inputStream, int pipeSize, Map<String, Object> inputArguments, OutputArgumentHandler outputArgumentHandler) throws DataMapperExecutionException {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(MULE_INPUT_PAYLOAD_KEY, inputStream);
        if (inputArguments != null) {
            arguments.putAll(inputArguments);
        }
        T currentGraph = this.asyncGraphProvider.takeGraph();
        MappingFormat outputType = this.getEngine().getOutputType(currentGraph);
        if (outputType.isFileBased()) {
            return this.executeFileStreaming(pipeSize, currentGraph, arguments, outputArgumentHandler);
        }
        return this.executeObjectStreaming(pipeSize, currentGraph, arguments, outputArgumentHandler);
    }

    @Override
    public String getOutputContentType() {
        T currentGraph = this.graphProvider.takeGraph();
        try {
            String string = this.getEngine().getOutputType(currentGraph).getContentType();
            return string;
        }
        finally {
            this.graphProvider.releaseGraph(currentGraph);
        }
    }

    @Override
    public String getOutputEncoding() {
        T currentGraph = this.graphProvider.takeGraph();
        try {
            String string = this.getEngine().getOutputEncoding(currentGraph);
            return string;
        }
        finally {
            this.graphProvider.releaseGraph(currentGraph);
        }
    }

    private Object executeFileStreaming(int pipeSize, T currentGraph, Map<String, Object> arguments, OutputArgumentHandler outputArgumentHandler) throws DataMapperExecutionException {
        PipedOutputStream outputSink = new PipedOutputStream();
        arguments.put(MULE_OUTPUT_PAYLOAD_KEY, outputSink);
        PipedInputStream inputSource = null;
        try {
            inputSource = new PipedInputStream(outputSink, pipeSize);
            this.getEngine().executeLater(currentGraph, arguments, new GraphExecutionCallback(currentGraph, null, outputArgumentHandler));
            return inputSource;
        }
        catch (DataMapperExecutionException e) {
            this.asyncGraphProvider.invalidateObject(currentGraph);
            try {
                outputSink.close();
            }
            catch (IOException e1) {
                logger.error((Object)"Error closing outputSink");
            }
            try {
                inputSource.close();
            }
            catch (IOException e1) {
                logger.error((Object)"Error closing inputSource");
            }
            logger.error((Object)"Exception while executing transformation graph", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.asyncGraphProvider.invalidateObject(currentGraph);
            logger.error((Object)"Exception while initializing the graph", e);
            throw new RuntimeException(e);
        }
    }

    public TransformationEngine<T> getEngine() {
        return this.engine;
    }

    private class GraphExecutionCallback
    implements FutureCallback<TransformationResult> {
        private final T graph;
        private Closeable closeable;
        private OutputArgumentHandler outputArgumentHandler;
        private Throwable throwable;

        public GraphExecutionCallback(T graph, Closeable closeable, OutputArgumentHandler outputArgumentHandler) {
            this.graph = graph;
            this.closeable = closeable;
            this.outputArgumentHandler = outputArgumentHandler;
        }

        @Override
        public void done(TransformationResult result) {
            Map<String, Object> otherResults = result.getOutputArguments();
            for (Map.Entry<String, Object> outputArgument : otherResults.entrySet()) {
                this.outputArgumentHandler.addArgument(outputArgument.getKey(), outputArgument.getValue());
            }
            this.release();
        }

        @Override
        public void failed(Throwable throwable) {
            this.throwable = throwable;
            logger.error((Object)"Error while executing graph ", throwable);
            this.release();
        }

        @Override
        public void cancelled() {
            this.release();
        }

        private void release() {
            if (this.throwable != null) {
                DefaultGraphExecutor.this.asyncGraphProvider.invalidateObject(this.graph);
            } else {
                DefaultGraphExecutor.this.asyncGraphProvider.releaseGraph(this.graph);
            }
            try {
                if (this.closeable != null) {
                    this.closeable.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error while closing  ", (Throwable)e);
            }
        }
    }
}

