/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.processors;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessors;
import org.mule.config.i18n.MessageFactory;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;

public class TryResource
extends AbstractMessageProcessorOwner
implements MessageProcessor {
    private List<MessageProcessor> messageProcessors;
    private MessageProcessor headMP;
    private MessageProcessor tailMP;
    private boolean suppressedException;

    public void initialise() throws InitialisationException {
        if (this.messageProcessors.isEmpty()) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Try resource must have at least one inner message processor."), (Initialisable)this);
        }
        this.headMP = MessageProcessors.singletonChain((MessageProcessor)this.messageProcessors.get(0));
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder();
        defaultMessageProcessorChainBuilder.chain(this.messageProcessors.subList(1, this.messageProcessors.size()));
        try {
            this.tailMP = defaultMessageProcessorChainBuilder.build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        super.initialise();
    }

    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent process(MuleEvent event) throws MuleException {
        Closeable resource = null;
        try {
            MuleEvent process = this.headMP.process(event);
            Object payload = process.getMessage().getPayload();
            resource = this.asCloseable(payload);
            MuleEvent muleEvent = this.tailMP.process(process);
            return muleEvent;
        }
        finally {
            block11: {
                try {
                    if (resource != null) {
                        resource.close();
                    }
                }
                catch (IOExceptionAdapter e) {
                    if (!this.isSuppressedException()) {
                        throw new DefaultMuleException(e.getCause());
                    }
                }
                catch (IOException e) {
                    if (this.isSuppressedException()) break block11;
                    throw new DefaultMuleException((Throwable)e);
                }
            }
        }
    }

    private Closeable asCloseable(Object payload) throws DefaultMuleException {
        Closeable resource;
        if (payload instanceof Closeable) {
            resource = (Closeable)payload;
        } else {
            try {
                Method close = payload.getClass().getMethod("close", new Class[0]);
                resource = new CloseableProxyClass(payload, close);
            }
            catch (NoSuchMethodException e) {
                throw new DefaultMuleException("Payload must be instance of " + Closeable.class + " or at least have a close() method declare");
            }
        }
        return resource;
    }

    public boolean isSuppressedException() {
        return this.suppressedException;
    }

    public void setSuppressedException(boolean suppressedException) {
        this.suppressedException = suppressedException;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void setHeadMP(MessageProcessor headMP) {
        this.headMP = headMP;
    }

    public void setTailMP(MessageProcessor tailMP) {
        this.tailMP = tailMP;
    }

    private class IOExceptionAdapter
    extends IOException {
        private IOExceptionAdapter(Throwable throwable) {
            super(throwable);
        }
    }

    private class CloseableProxyClass
    implements Closeable {
        private Object toDelegate;
        private Method closeMethod;

        private CloseableProxyClass(Object toDelegate, Method closeMethod) {
            this.toDelegate = toDelegate;
            this.closeMethod = closeMethod;
        }

        @Override
        public void close() throws IOException {
            try {
                this.closeMethod.invoke(this.toDelegate, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IOExceptionAdapter(e);
            }
            catch (InvocationTargetException e) {
                throw new IOExceptionAdapter(e.getCause());
            }
        }
    }
}

