/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.util;

import com.mulesoft.datamapper.exception.DataMapperRuntimeException;
import com.mulesoft.mule.module.datamapper.clover.impl.graphprovider.CloverEventFilter;
import com.mulesoft.mule.module.datamapper.util.StaxEventXMLReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.mule.api.MuleContext;
import org.mule.util.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DataMapperUtils {
    private static final boolean validation = false;
    private static final boolean putCDATAIntoText = true;
    private static final boolean createEntityRefs = false;
    public static final String FILTERUNSEDMETADATA_PROPERTY = "com.mulesoft.datamapper.filterunsedmetadata";

    public static String getAppHome(MuleContext muleContext) {
        return (String)muleContext.getRegistry().get("app.home");
    }

    public static File getMappingFile(MuleContext muleContext, String grfName) {
        return new File(DataMapperUtils.getAppHome(muleContext), grfName);
    }

    public static Document parseDocument(MuleContext muleContext, String grfName) {
        Document document;
        DOMResult result = new DOMResult();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        xmlInputFactory.setProperty("javax.xml.stream.isValidating", false);
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        try {
            StreamSource source;
            File mappingFile = DataMapperUtils.getMappingFile(muleContext, grfName);
            if (!mappingFile.exists()) {
                URL resourceAsUrl = IOUtils.getResourceAsUrl((String)grfName, DataMapperUtils.class);
                if (resourceAsUrl == null) {
                    throw new DataMapperRuntimeException("The data mapping graph " + grfName + " does not exists");
                }
                try {
                    source = new StreamSource(resourceAsUrl.openStream());
                }
                catch (IOException e) {
                    throw new DataMapperRuntimeException("Problem when loading " + grfName + " .", e);
                }
            } else {
                source = new StreamSource(mappingFile);
            }
            XMLEventReader reader = xmlInputFactory.createXMLEventReader(source);
            if (Boolean.getBoolean(FILTERUNSEDMETADATA_PROPERTY)) {
                reader = xmlInputFactory.createFilteredReader(reader, new CloverEventFilter());
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(new StaxSource(reader), result);
            document = (Document)result.getNode();
        }
        catch (XMLStreamException e) {
            throw new DataMapperRuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new DataMapperRuntimeException(e);
        }
        catch (TransformerException e) {
            throw new DataMapperRuntimeException(e);
        }
        return document;
    }

    public static class StaxSource
    extends SAXSource {
        private XMLEventReader eventReader;

        public StaxSource(XMLEventReader eventReader) {
            super(new StaxEventXMLReader(eventReader), new InputSource());
            this.eventReader = eventReader;
        }

        XMLEventReader getXMLEventReader() {
            return this.eventReader;
        }

        @Override
        public void setInputSource(InputSource inputSource) {
            throw new UnsupportedOperationException("setInputSource is not supported");
        }

        @Override
        public void setXMLReader(XMLReader reader) {
            throw new UnsupportedOperationException("setXMLReader is not supported");
        }
    }
}

