/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.util;

import com.mulesoft.mule.module.datamapper.util.DataRecordBuilder;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetel.data.DataField;
import org.jetel.data.DataRecord;
import org.jetel.metadata.DataRecordMetadata;

public class PojoDataRecordBuilder
implements DataRecordBuilder {
    private static Logger logger = Logger.getLogger(PojoDataRecordBuilder.class.getName());

    @Override
    public boolean handles(Object object) {
        return !(object instanceof Map);
    }

    @Override
    public DataRecord buildFrom(DataRecordMetadata metadata, Object pojo) {
        if (pojo == null) {
            return new DataRecord(metadata);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(pojo.getClass(), Object.class);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            DataRecord record = new DataRecord(metadata);
            record.init();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                if (propertyDescriptor.getWriteMethod() == null || propertyDescriptor.getReadMethod() == null) continue;
                Object value = null;
                try {
                    value = propertyDescriptor.getReadMethod().invoke(pojo, new Object[0]);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error invoking reflect method", e);
                }
                this.addFieldIfExistsMetadata(record, propertyDescriptor.getName(), value);
            }
            return record;
        }
        catch (IntrospectionException e) {
            logger.log(Level.WARNING, "Error invoking reflect method", e);
            return null;
        }
    }

    private void addFieldIfExistsMetadata(DataRecord dataRecord, String key, Object value) {
        DataField dataField;
        String fieldName = key.toLowerCase();
        if (dataRecord.hasField(fieldName) && (dataField = dataRecord.getField(fieldName)) != null) {
            dataField.setValue(value);
        }
    }
}

