/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.api.queue;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.munit.mtf.tools.internal.error.QueueTimeOutException;
import org.mule.munit.runner.component.rules.TestRule;
import org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;

public class TemporaryQueueRule
implements TestRule {
    @Inject
    @Named(value="_muleQueueManager")
    protected QueueManager queueManager;
    private Map<String, Queue> queues = new HashMap<String, Queue>();

    public void push(Serializable value, String queueName) {
        this.executeOnQueue(queueName, queue -> {
            queue.put(value);
            return null;
        });
    }

    public Serializable pop(String queueName, Long timeOut) {
        if (Objects.isNull(timeOut)) {
            return this.executeOnQueue(queueName, Queue::take);
        }
        return this.executeOnQueue(queueName, queue -> queue.poll(timeOut.longValue()));
    }

    public int size(String queueName) {
        return this.executeOnQueue(queueName, Queue::size);
    }

    public void reset() {
        this.queues.keySet().forEach(q -> this.executeOnQueue((String)q, queue -> {
            queue.clear();
            return null;
        }));
    }

    private <T> T executeOnQueue(String queue, TemporaryQueueTask<T> task) {
        try {
            return task.run(this.queues.computeIfAbsent(queue, queueName -> {
                this.queueManager.setQueueConfiguration(queueName, (QueueConfiguration)new DefaultQueueConfiguration());
                return this.queueManager.getQueueSession().getQueue(queueName);
            }));
        }
        catch (InterruptedException e) {
            throw new QueueTimeOutException(e);
        }
    }

    @FunctionalInterface
    private static interface TemporaryQueueTask<T> {
        public T run(Queue var1) throws InterruptedException;
    }
}

