/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.queue;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.munit.mtf.tools.api.queue.TemporaryQueueRule;
import org.mule.munit.mtf.tools.internal.error.QueueTimeOutException;
import org.mule.munit.mtf.tools.internal.queue.QueueErrorTypeProvider;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class QueueOperations {
    public static final String DEFAULT_QUEUE_NAME = "MTF_QUEUE";
    @Inject
    protected TemporaryQueueRule temporaryQueueRule;

    @Throws(value={QueueErrorTypeProvider.class})
    public void queue(@Content TypedValue<Serializable> value, @org.mule.runtime.extension.api.annotation.param.Optional String queueName) {
        this.temporaryQueueRule.push((Serializable)value, QueueOperations.getQueueName(queueName));
    }

    @Throws(value={QueueErrorTypeProvider.class})
    public Result<Serializable, Void> dequeue(@org.mule.runtime.extension.api.annotation.param.Optional String queueName, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="10000") Long timeout, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="MILLISECONDS") TimeUnit timeoutUnit) {
        return Optional.ofNullable(this.temporaryQueueRule.pop(QueueOperations.getQueueName(queueName), timeoutUnit.toMillis(timeout))).map(this::asResult).orElseThrow(QueueTimeOutException::new);
    }

    private Result<Serializable, Void> asResult(Object value) {
        TypedValue typedValue = value instanceof TypedValue ? (TypedValue)value : new TypedValue((Object)((Serializable)value), DataType.fromType(value.getClass()));
        return Result.builder().output(typedValue.getValue()).mediaType(typedValue.getDataType().getMediaType()).build();
    }

    @Ignore
    static String getQueueName(String queueName) {
        return queueName != null ? queueName : DEFAULT_QUEUE_NAME;
    }
}

