/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.error;

import static org.mule.munit.mtf.tools.internal.error.MTFToolsErrorDefinition.QUEUE_TIMEOUT;

import org.mule.runtime.extension.api.exception.ModuleException;

/**
 * Exception thrown when an {@link InterruptedException} is thrown when performing operations over a queue
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class QueueTimeOutException extends ModuleException {


  public QueueTimeOutException() {
    super("Time out waiting for queue to return a result", QUEUE_TIMEOUT);
  }

  public QueueTimeOutException(Throwable cause) {
    super("An error occurred while waiting for queue to return a result", QUEUE_TIMEOUT, cause);
  }
}
