/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.queue;

import static com.google.common.collect.Sets.newHashSet;
import static org.mule.munit.mtf.tools.internal.error.MTFToolsErrorDefinition.QUEUE_TIMEOUT;

import java.util.Set;

import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

/**
 * {@link ErrorTypeProvider} implementation for queue operations
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class QueueErrorTypeProvider implements ErrorTypeProvider {

  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    return newHashSet(QUEUE_TIMEOUT);
  }
}
