/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.queue;

import static org.mule.munit.mtf.tools.internal.queue.QueueOperations.getQueueName;

import javax.inject.Inject;

import org.mule.munit.mtf.tools.api.queue.TemporaryQueueRule;
import org.mule.runtime.extension.api.annotation.param.Optional;

/**
 * Helper functions that provide information about the temporary queue
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class QueueFunctions {

  @Inject
  private TemporaryQueueRule temporaryQueueRule;

  public Integer queueSize(@Optional String queueName) {
    return temporaryQueueRule.size(getQueueName(queueName));
  }

}
