/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.persistence.api.JsonMetadataTypeWriterFactory;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.MetadataTestException;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.UnexpectedMetadataFailureException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetadataScope
implements Lifecycle {
    @Inject
    protected PrivilegedMuleContext muleContext;
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractMetadataScope.class);
    @Named(value="_muleNonLazyMetadataService")
    @Inject
    protected MetadataService metadataService;
    protected TypeWriter metadataTypeWriter;
    protected Component component;

    public void setComponent(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public abstract Message getMetadata() throws MetadataTestException;

    public void stop() throws MuleException {
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.component, (Logger)LOGGER);
    }

    public void start() throws MuleException {
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.component, (MuleContext)this.muleContext);
        this.metadataTypeWriter = JsonMetadataTypeWriterFactory.create();
    }

    public CoreEvent process(CoreEvent incomingEvent) throws MetadataTestException {
        return CoreEvent.builder((CoreEvent)incomingEvent).message(this.getMetadata()).build();
    }

    protected Location getComponentLocation() {
        return Location.builderFromStringRepresentation((String)this.component.getLocation().getLocation()).build();
    }

    protected MetadataTestException metadataTestException(List<MetadataFailure> failures, MetadataComponent expectedComponent) {
        return new MetadataTestException(failures.stream().filter(metadataFailure -> metadataFailure.getFailingComponent().equals((Object)expectedComponent)).findAny().orElseThrow(() -> new UnexpectedMetadataFailureException(expectedComponent, failures)));
    }
}

