/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.api.config;

import static org.apache.commons.lang3.StringUtils.EMPTY;
import static org.mule.munit.mtf.tools.api.config.MtfXmlNamespaceInfoProvider.NAMESPACE;
import static org.mule.runtime.dsl.api.component.AttributeDefinition.Builder.fromChildCollectionConfiguration;
import static org.mule.runtime.dsl.api.component.AttributeDefinition.Builder.fromChildConfiguration;
import static org.mule.runtime.dsl.api.component.AttributeDefinition.Builder.fromSimpleParameter;
import static org.mule.runtime.dsl.api.component.TypeDefinition.fromType;

import java.util.LinkedList;
import java.util.List;

import org.mule.munit.mtf.tools.internal.tooling.ToolingTest;
import org.mule.munit.mtf.tools.internal.tooling.metadata.AbstractMetadataScope;
import org.mule.munit.mtf.tools.internal.tooling.metadata.GetAttributesMetadataScope;
import org.mule.munit.mtf.tools.internal.tooling.metadata.GetInputMetadataScope;
import org.mule.munit.mtf.tools.internal.tooling.metadata.GetMetadataKeysScope;
import org.mule.munit.mtf.tools.internal.tooling.metadata.GetOutputMetadataScope;
import org.mule.munit.mtf.tools.internal.tooling.metadata.processors.AssertTypeProcessor;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.objectfactory.MessageProcessorChainObjectFactory;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;

/**
 * {@link ComponentBuildingDefinitionProvider} for the MTF Tools Module
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MtfComponentBuildingDefinitionProvider implements ComponentBuildingDefinitionProvider {

  public static final String TOOLING_TEST = "tooling-test";
  public static final String NAME_FIELD = "name";
  public static final String IGNORE_FIELD = "ignore";
  public static final String DESCRIPTION_FIELD = "description";
  public static final String TAGS_FIELD = "tags";
  public static final String VALIDATION_SCOPE = "validation";
  public static final String GET_METADATA_KEYS_SCOPE_IDENTIFIER = "get-metadata-keys";
  public static final String GET_OUTPUT_METADATA_IDENTIFIER = "get-output-metadata";
  public static final String GET_ATTRIBUTES_METADATA_IDENTIFIER = "get-attributes-metadata";
  public static final String GET_INPUT_METADATA_IDENTIFIER = "get-input-metadata";
  public static final String METADATA_SCOPE_PARAMETER = "metadataScope";
  public static final String EXPECT_FAILURE_CODE_FIELD = "expectFailureCode";
  public static final String EXPECT_FAILURE_MESSAGE_FIELD = "expectFailureMessage";
  public static final String COMPONENT_SCOPE = "component";
  public static final String MESSAGE_PROCESSORS_FIELD = "messageProcessors";
  public static final String PARAMETER_FIELD = "parameter";
  public static final String ASSERT_TYPE_PROCESSOR = "assert-type";
  public static final String ACTUAL_FIELD = "actual";
  public static final String FROM_CLASS_FIELD = "fromClass";
  public static final String FROM_SCHEMA_FIELD = "fromSchema";

  private static ComponentBuildingDefinition.Builder baseDefinition =
      new ComponentBuildingDefinition.Builder().withNamespace(NAMESPACE);

  @Override
  public void init() {

  }

  @Override
  public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
    List<ComponentBuildingDefinition> componentBuildingDefinitions = new LinkedList<>();

    componentBuildingDefinitions.add(
                                     baseDefinition
                                         .withIdentifier(TOOLING_TEST)
                                         .withTypeDefinition(fromType(ToolingTest.class))
                                         .withSetterParameterDefinition(NAME_FIELD, fromSimpleParameter(NAME_FIELD).build())
                                         .withSetterParameterDefinition(IGNORE_FIELD,
                                                                        fromSimpleParameter(IGNORE_FIELD).withDefaultValue(false)
                                                                            .build())
                                         .withSetterParameterDefinition(DESCRIPTION_FIELD,
                                                                        fromSimpleParameter(DESCRIPTION_FIELD)
                                                                            .withDefaultValue(EMPTY).build())
                                         .withSetterParameterDefinition(TAGS_FIELD, fromSimpleParameter(TAGS_FIELD).build())
                                         .withSetterParameterDefinition(EXPECT_FAILURE_CODE_FIELD,
                                                                        fromSimpleParameter(EXPECT_FAILURE_CODE_FIELD).build())
                                         .withSetterParameterDefinition(EXPECT_FAILURE_MESSAGE_FIELD,
                                                                        fromSimpleParameter(EXPECT_FAILURE_MESSAGE_FIELD).build())
                                         .withSetterParameterDefinition(METADATA_SCOPE_PARAMETER,
                                                                        fromChildConfiguration(AbstractMetadataScope.class)
                                                                            .build())
                                         .withSetterParameterDefinition(VALIDATION_SCOPE,
                                                                        fromChildConfiguration(MessageProcessorChain.class)
                                                                            .withIdentifier(VALIDATION_SCOPE).build())
                                         .build());
    componentBuildingDefinitions.add(
                                     baseDefinition.withIdentifier(GET_METADATA_KEYS_SCOPE_IDENTIFIER)
                                         .withTypeDefinition(fromType(GetMetadataKeysScope.class))
                                         .withSetterParameterDefinition(COMPONENT_SCOPE,
                                                                        fromChildConfiguration(Component.class).build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.withIdentifier(GET_OUTPUT_METADATA_IDENTIFIER)
                                         .withTypeDefinition(fromType(GetOutputMetadataScope.class))
                                         .withSetterParameterDefinition(COMPONENT_SCOPE,
                                                                        fromChildConfiguration(Component.class).build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.withIdentifier(GET_ATTRIBUTES_METADATA_IDENTIFIER)
                                         .withTypeDefinition(fromType(GetAttributesMetadataScope.class))
                                         .withSetterParameterDefinition(COMPONENT_SCOPE,
                                                                        fromChildConfiguration(Component.class).build())
                                         .build());
    componentBuildingDefinitions.add(
                                     baseDefinition.withIdentifier(GET_INPUT_METADATA_IDENTIFIER)
                                         .withTypeDefinition(fromType(GetInputMetadataScope.class))
                                         .withSetterParameterDefinition(PARAMETER_FIELD,
                                                                        fromSimpleParameter(PARAMETER_FIELD).build())
                                         .withSetterParameterDefinition(COMPONENT_SCOPE,
                                                                        fromChildConfiguration(Component.class).build())
                                         .build());

    componentBuildingDefinitions.add(
                                     baseDefinition.withIdentifier(VALIDATION_SCOPE)
                                         .withTypeDefinition(fromType(MessageProcessorChain.class))
                                         .withObjectFactoryType(MessageProcessorChainObjectFactory.class)
                                         .withSetterParameterDefinition(MESSAGE_PROCESSORS_FIELD,
                                                                        fromChildCollectionConfiguration(Processor.class).build())
                                         .asPrototype().build());

    componentBuildingDefinitions
        .add(baseDefinition.withIdentifier(ASSERT_TYPE_PROCESSOR).withTypeDefinition(fromType(AssertTypeProcessor.class))
            .withSetterParameterDefinition(ACTUAL_FIELD, fromSimpleParameter(ACTUAL_FIELD).build())
            .withSetterParameterDefinition(FROM_CLASS_FIELD, fromSimpleParameter(FROM_CLASS_FIELD).build())
            .withSetterParameterDefinition(FROM_SCHEMA_FIELD, fromSimpleParameter(FROM_SCHEMA_FIELD).build()).build());
    return componentBuildingDefinitions;
  }
}
