/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.api.config;

import static java.util.Arrays.asList;

import org.mule.runtime.dsl.api.xml.XmlNamespaceInfo;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;

import java.util.Collection;

/**
 * {@link XmlNamespaceInfoProvider} for the MTF Tools Module
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MtfXmlNamespaceInfoProvider implements XmlNamespaceInfoProvider {

  public static final String NAMESPACE = "mtf";
  public static final String NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/mtf";

  @Override
  public Collection<XmlNamespaceInfo> getXmlNamespacesInfo() {
    return asList(new XmlNamespaceInfo() {

      @Override
      public String getNamespaceUriPrefix() {
        return NAMESPACE_URI;
      }

      @Override
      public String getNamespace() {
        return NAMESPACE;
      }
    });
  }
}
