/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.api.tooling;

import static org.mule.munit.mtf.tools.api.config.MtfComponentBuildingDefinitionProvider.TOOLING_TEST;
import static org.mule.munit.mtf.tools.api.config.MtfXmlNamespaceInfoProvider.NAMESPACE;

import org.mule.munit.runner.component.TestComponentInfoProvider;
import org.mule.runtime.api.component.ComponentIdentifier;

/**
 * {@link TestComponentInfoProvider} for the mtf:tooling-test
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class ToolingTestComponentInfoProvider implements TestComponentInfoProvider {

  @Override
  public ComponentIdentifier getComponentIdentifier() {
    return ComponentIdentifier.builder().namespace(NAMESPACE).name(TOOLING_TEST).build();
  }
}
