/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.MetadataTestException;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.source.MessageSource;

/**
 * Base class to implement a {@link AbstractMetadataScope} that provides metadata information about the
 * {@link org.mule.runtime.api.meta.model.ComponentModel}
 * 
 * @since 1.0.0
 * @author Mulesoft Inc.
 */
public abstract class ComponentModelMetadataScope extends AbstractMetadataScope {

  protected ConnectableComponentModel getComponentModel() throws MetadataTestException {
    MetadataResult<? extends ComponentMetadataDescriptor<? extends ConnectableComponentModel>> componentMetadata;
    if (component instanceof MessageSource) {
      componentMetadata = metadataService.getSourceMetadata(getComponentLocation());
    } else {
      componentMetadata = metadataService.getOperationMetadata(getComponentLocation());
    }
    if (componentMetadata.isSuccess()) {
      return componentMetadata.get().getModel();
    } else {
      throw metadataTestException(componentMetadata.getFailures(), getMetadataComponent());
    }
  }

  protected abstract MetadataComponent getMetadataComponent();

}
