/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import static com.google.common.base.Preconditions.checkArgument;
import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import org.mule.metadata.api.model.MetadataType;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.MetadataTestException;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;

/**
 * Scope that gets the input metadata from the component's parameter
 * 
 * @since 1.0.0
 * @author Mulesoft Inc.
 */
public class GetInputMetadataScope extends MetadataTypeWriterScope {

  private String parameter;

  public void setParameter(String parameter) {
    this.parameter = parameter;
  }

  @Override
  protected MetadataType getMetadataType() throws MetadataTestException {
    return getParameterModel().getType();
  }

  @Override
  protected MetadataComponent getMetadataComponent() {
    return MetadataComponent.INPUT;
  }

  private ParameterModel getParameterModel() throws MetadataTestException {
    checkArgument(isNotBlank(parameter), "The 'parameter' field cannot be blank");
    return getComponentModel().getAllParameterModels().stream()
        .filter(parameterModel -> parameterModel.getName().equals(parameter)).findAny()
        .orElseThrow(() -> new IllegalArgumentException(format("Parameter [%s] was not found for component located at: %s",
                                                               parameter, component.getLocation())));
  }

}
