/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import static org.mule.munit.mtf.tools.internal.tooling.metadata.model.MetadataKeyAdapter.convertToMap;

import java.util.Map;
import java.util.Set;

import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.MetadataTestException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

/**
 * Scope that gets the metadata keys from the component
 * 
 * @since 1.0.0
 * @author Mulesoft Inc.
 */
public class GetMetadataKeysScope extends AbstractMetadataScope {

  @Override
  public Message getMetadata() throws MetadataTestException {
    MetadataResult<MetadataKeysContainer> metadataResult = metadataService.getMetadataKeys(getComponentLocation());
    if (metadataResult.isSuccess()) {
      Map<String, Set<MetadataKey>> keysByCategory = metadataResult.get().getKeysByCategory();
      if (keysByCategory.size() == 1) {
        Set<MetadataKey> metadataKeys = keysByCategory.values().iterator().next();
        return Message.of(convertToMap(metadataKeys));
      } else {
        throw new IllegalStateException("Unable to get metadata keys: Number of categories should be only one");
      }
    } else {
      throw metadataTestException(metadataResult.getFailures(), MetadataComponent.KEYS);
    }
  }

}
