/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import org.mule.metadata.api.model.MetadataType;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.MetadataTestException;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;

/**
 * Scope that gets the output metadata from the component
 * 
 * @since 1.0.0
 * @author Mulesoft Inc.
 */
public class GetOutputMetadataScope extends MetadataTypeWriterScope {

  @Override
  protected MetadataType getMetadataType() throws MetadataTestException {
    return getComponentModel().getOutput().getType();
  }

  @Override
  protected MetadataComponent getMetadataComponent() {
    return MetadataComponent.OUTPUT_PAYLOAD;
  }

}
