/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import org.mule.metadata.api.model.MetadataType;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.MetadataTestException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;

/**
 * Base class to implement a {@link ComponentModelMetadataScope} that serializes a {@link MetadataType} and returns it as a Json
 * string inside the {@link Message}
 * 
 * @since 1.0.0
 * @author Mulesoft Inc.
 */
public abstract class MetadataTypeWriterScope extends ComponentModelMetadataScope {


  @Override
  public Message getMetadata() throws MetadataTestException {
    String metadataTypeAsString = metadataTypeWriter.toString(getMetadataType());
    return Message.builder().payload(new TypedValue<>(metadataTypeAsString, DataType.JSON_STRING)).build();
  }

  /**
   * Gets the {@link MetadataType} to be serialized and returned in the {@link Message}
   * 
   * @return Metadata type to be serialized
   */
  protected abstract MetadataType getMetadataType() throws MetadataTestException;

}

