/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata.exception;

import org.mule.runtime.api.metadata.resolving.MetadataFailure;

/**
 * An exception thrown during the Metadata Calculation in a Test
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MetadataTestException extends Exception {

  private MetadataFailure metadataFailure;

  public MetadataTestException(MetadataFailure metadataFailure) {
    super(asMessage(metadataFailure));
    this.metadataFailure = metadataFailure;
  }

  private static String asMessage(MetadataFailure metadataFailure) {
    return "Failure code: " + metadataFailure.getFailureCode() + ", Reason: " + metadataFailure.getReason();
  }

  public MetadataFailure getMetadataFailure() {
    return metadataFailure;
  }
}
