/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata.exception;

import java.util.List;

import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;

/**
 * Exception thrown when the {@link MetadataFailure} thrown for a component does not match the expected one. For example, if
 * testing the {@link MetadataComponent#OUTPUT_PAYLOAD} of a component but a {@link MetadataComponent#OUTPUT_ATTRIBUTES} failure
 * is thrown, this exception would be thrown.
 * 
 * @since 1.0.0
 * @author Mulesoft Inc.
 */
public class UnexpectedMetadataFailureException extends RuntimeException {

  public UnexpectedMetadataFailureException(MetadataComponent expectedComponent, List<MetadataFailure> failures) {
    super(createMessage(expectedComponent, failures));
  }

  private static String createMessage(MetadataComponent expectedComponent, List<MetadataFailure> failures) {
    return "An unexpected metadata failure occurred: Expected a failure of component ["
        + expectedComponent + "] but got the following failures from other components: " + failures;
  }
}
