/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata.model;

import static java.util.stream.Collectors.toMap;
import static org.mule.runtime.api.util.Preconditions.checkArgument;

import java.util.Map;
import java.util.Set;

import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataProperty;

/**
 * Adapter for a {@link MetadataKey} to improve the assertion experience in a test
 * 
 * @since 1.0.0
 * @author Mulesoft Inc.
 */
public class MetadataKeyAdapter {

  private final MetadataKey metadataKey;

  private MetadataKeyAdapter(MetadataKey metadataKey) {
    checkArgument(metadataKey != null, "Metadata Key cannot be null");
    this.metadataKey = metadataKey;
  }

  public static Map<String, MetadataKeyAdapter> convertToMap(Set<MetadataKey> metadataKeys) {
    return metadataKeys.stream().collect(toMap(MetadataKey::getId, MetadataKeyAdapter::new));
  }

  public String getId() {
    return metadataKey.getId();
  }

  public String getDisplayName() {
    return metadataKey.getDisplayName();
  }

  public String getPartName() {
    return metadataKey.getPartName();
  }

  public Set<MetadataProperty> getProperties() {
    return metadataKey.getProperties();
  }

  public Map<String, MetadataKeyAdapter> getChilds() {
    return convertToMap(metadataKey.getChilds());
  }

  @Override
  public String toString() {
    return metadataKey.toString();
  }
}
