/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.metadata.MetadataTypeWriterScope;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;

public class GetInputMetadataScope
extends MetadataTypeWriterScope {
    private String parameter;

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    @Override
    protected MetadataType getMetadataType() throws ToolingTestException {
        return this.getParameterModel().getType();
    }

    @Override
    protected MetadataComponent getMetadataComponent() {
        return MetadataComponent.INPUT;
    }

    private ParameterModel getParameterModel() throws ToolingTestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.parameter), (Object)"The 'parameter' field cannot be blank");
        return this.getComponentModel().getAllParameterModels().stream().filter(parameterModel -> parameterModel.getName().equals(this.parameter)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Parameter [%s] was not found for component located at: %s", this.parameter, this.component.getLocation())));
    }
}

