/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.api;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.munit.mtf.tools.internal.tooling.values.model.ValuesAdapter;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class MtfExtensionLoadingDelegate
implements ExtensionLoadingDelegate {
    private static final String VERSION = "1.0.0-SNAPSHOT";
    private static final String DESCRIPTION = "MTF: Tools";
    private static final String NAME = "MTF Tools";
    private static final String VENDOR = "MuleSoft, Inc.";
    private static final MuleVersion MIN_MULE_VERSION = new MuleVersion("4.2.0");
    private static final String PREFIX = "mtf";
    private static final String NAMESPACE = "http://www.mulesoft.org/schema/mule/mtf";
    private static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/mtf/current/mule-mtf.xsd";
    private static final String SCHEMA_VERSION = "1.0.0-SNAPSHOT";
    private static final String XSD_FILE_NAME = "mule-mtf.xsd";
    private static final String TOOLING_TEST_NAME = "tooling-test";
    private static final String TOOLING_TEST_DESCRIPTION = "The Tooling test";
    private static final String NAME_NAME = "name";
    private static final String NAME_DESCRIPTION = "Name of the test";
    private static final String DESCRIPTION_NAME = "description";
    private static final String DESCRIPTION_DESCRIPTION = "Description message to be shown in case of test failure.";
    private static final String IGNORE_NAME = "ignore";
    private static final String IGNORE_DESCRIPTION = "Defines if the test must be ignored.";
    private static final String TAGS_NAME = "tags";
    private static final String TAGS_DESCRIPTION = "Defines the tags for the test.";
    private static final String EXPECTED_FAILURE_CODE_NAME = "expectFailureCode";
    private static final String EXPECTED_FAILURE_CODE_DESCRIPTION = "Failure code expected on this test.";
    private static final String EXPECTED_FAILURE_MESSAGE_NAME = "expectFailureMessage";
    private static final String EXPECTED_FAILURE_MESSAGE_DESCRIPTION = "Failure message expected on this test.";
    private static final String GET_METADATA_KEYS = "get-metadata-keys";
    private static final String GET_METADATA_KEYS_DESCRIPTION = "Gets the metadata keys of the component";
    private static final String GET_OUTPUT_METADATA = "get-output-metadata";
    private static final String GET_OUTPUT_METADATA_DESCRIPTION = "Gets the output metadata of the component";
    private static final String GET_ATTRIBUTES_METADATA = "get-attributes-metadata";
    private static final String GET_ATTRIBUTES_DESCRIPTION = "Gets the attributes metadata of the component";
    private static final String GET_INPUT_METADATA = "get-input-metadata";
    private static final String GET_INPUT_METADATA_DESCRIPTION = "Gets the input metadata of the component's parameter";
    private static final String GET_VALUES = "get-values";
    private static final String GET_VALUES_DESCRIPTION = "Gets the values of the component's parameter";
    private static final String GET_VALUES_FROM_CONFIG = "get-values-from-config";
    private static final String GET_VALUES_FROM_CONFIG_DESCRIPTION = "Gets the values of the configurations's parameter";
    private static final String GET_VALUES_FROM_CONFIG_REF = "config-ref";
    private static final String GET_VALUES_FROM_CONFIG_REF_DESCRIPTION = "Configuration containing the parameter";
    private static final String VALIDATION_NAME = "validation";
    private static final String VALIDATION_DESCRIPTION = "Processors that define validation of the test";
    private static final String NESTED_COMPONENT_NAME = "component";
    private static final String NESTED_COMPONENT_DESCRIPTION = "Component over which tooling information is obtained";
    private static final String TOOLING_SCOPE_NAME = "toolingScope";
    private static final String TOOLING_SCOPE_DESCRIPTION = "Scope that calculates tooling information over a component";
    private static final String TOOLING_PARAMETER = "parameter";
    private static final String TOOLING_PARAMETER_DESCRIPTION = "Component's parameter over which to calculate tooling info";
    private static final String ASSERT_TYPE_PROCESSOR = "assert-type";
    private static final String ASSERT_TYPE_PROCESSOR_DESCRIPTION = "Asserts if two Metadata types are equal";
    private static final String ACTUAL_PARAMETER = "actual";
    private static final String ACTUAL_PARAMETER_DESCRIPTION = "Actual metadata type to compare";
    private static final String FROM_CLASS_PARAMETER = "fromClass";
    private static final String FROM_CLASS_PARAMETER_DESCRIPTION = "Compares to a Metadata Type obtained from a Java class";
    private static final String FROM_SCHEMA_PARAMETER = "fromSchema";
    private static final String FROM_SCHEMA_PARAMETER_DESCRIPTION = "Compares to a Metadata Type obtained from a schema file";
    private static final String TEST_CONNECTIVITY_NAME = "testConnectivity";
    private static final String TEST_CONNECTIVITY_DESCRIPTION = "Tests a connection over a configuration";
    private static final String CONFIG_REF_NAME = "config-ref";
    private static final String CONFIG_REF_DESCRIPTION = "Reference to the configuration";
    private static final StereotypeModel TOOLING_SCOPE_STEREOTYPE = StereotypeModelBuilder.newStereotype((String)"toolingScope", (String)"mtf").build();
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA);

    public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext extensionLoadingContext) {
        this.declareGeneral(extensionDeclarer);
        this.declareXmlDsl(extensionDeclarer);
        this.declareToolingTest(extensionDeclarer);
        this.declareToolingScopes(extensionDeclarer);
        this.declareProcessors(extensionDeclarer);
    }

    private void declareGeneral(ExtensionDeclarer extensionDeclarer) {
        extensionDeclarer.named(NAME).describedAs(DESCRIPTION).onVersion("1.0.0-SNAPSHOT").fromVendor(VENDOR).withCategory(Category.COMMUNITY);
    }

    private void declareXmlDsl(ExtensionDeclarer extensionDeclarer) {
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix(PREFIX).setNamespace(NAMESPACE).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("1.0.0-SNAPSHOT").setXsdFileName(XSD_FILE_NAME).build();
        extensionDeclarer.withXmlDsl(xmlDslModel);
    }

    private void declareToolingTest(ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer testDeclarer = ((ConstructDeclarer)extensionDeclarer.withConstruct(TOOLING_TEST_NAME).describedAs(TOOLING_TEST_DESCRIPTION)).allowingTopLevelDefinition();
        ParameterGroupDeclarer parameterGroupDeclarer = testDeclarer.onDefaultParameterGroup();
        ParameterDeclarer nameParam = parameterGroupDeclarer.withRequiredParameter(NAME_NAME).describedAs(NAME_DESCRIPTION).ofType(this.typeLoader.load(String.class)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        try {
            Method declaredMethod = ParameterDeclarer.class.getDeclaredMethod("asComponentId", new Class[0]);
            nameParam = (ParameterDeclarer)declaredMethod.invoke((Object)nameParam, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        this.addOptionalParameter(DESCRIPTION_NAME, DESCRIPTION_DESCRIPTION, String.class, parameterGroupDeclarer);
        this.addOptionalParameter(IGNORE_NAME, IGNORE_DESCRIPTION, Boolean.class, parameterGroupDeclarer);
        this.addOptionalParameter(TAGS_NAME, TAGS_DESCRIPTION, String.class, parameterGroupDeclarer);
        this.addOptionalParameter(EXPECTED_FAILURE_CODE_NAME, EXPECTED_FAILURE_CODE_DESCRIPTION, String.class, parameterGroupDeclarer);
        this.addOptionalParameter(EXPECTED_FAILURE_MESSAGE_NAME, EXPECTED_FAILURE_MESSAGE_DESCRIPTION, String.class, parameterGroupDeclarer);
        testDeclarer.withComponent(TOOLING_SCOPE_NAME).describedAs(TOOLING_SCOPE_DESCRIPTION).withAllowedStereotypes(new StereotypeModel[]{TOOLING_SCOPE_STEREOTYPE});
        this.declareTestSection(VALIDATION_NAME, VALIDATION_DESCRIPTION, extensionDeclarer, testDeclarer);
    }

    private void declareTestSection(String name, String description, ExtensionDeclarer extensionDeclarer, ConstructDeclarer testDeclarer) {
        StereotypeModel stereoType = StereotypeModelBuilder.newStereotype((String)name, (String)PREFIX).build();
        ((ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct(name).describedAs(description)).withStereotype(stereoType)).withChain();
        testDeclarer.withOptionalComponent(name).withAllowedStereotypes(new StereotypeModel[]{stereoType});
    }

    private void declareToolingScopes(ExtensionDeclarer extensionDeclarer) {
        this.declareToolingScope(GET_METADATA_KEYS, GET_METADATA_KEYS_DESCRIPTION, extensionDeclarer);
        this.declareToolingScope(GET_OUTPUT_METADATA, GET_OUTPUT_METADATA_DESCRIPTION, extensionDeclarer);
        this.declareToolingScope(GET_ATTRIBUTES_METADATA, GET_ATTRIBUTES_DESCRIPTION, extensionDeclarer);
        ConstructDeclarer inputMetadataScope = this.declareToolingScope(GET_INPUT_METADATA, GET_INPUT_METADATA_DESCRIPTION, extensionDeclarer);
        inputMetadataScope.withComponent(TOOLING_PARAMETER).describedAs(TOOLING_PARAMETER_DESCRIPTION);
        ConstructDeclarer getValuesScope = this.declareToolingScope(GET_VALUES, GET_VALUES_DESCRIPTION, extensionDeclarer);
        getValuesScope.withComponent(TOOLING_PARAMETER).describedAs(TOOLING_PARAMETER_DESCRIPTION);
        this.declareGetValuesFromConfig(extensionDeclarer);
    }

    private ConstructDeclarer declareToolingScope(String name, String description, ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer constructDeclarer = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct(name).describedAs(description)).withStereotype(TOOLING_SCOPE_STEREOTYPE);
        constructDeclarer.withComponent(NESTED_COMPONENT_NAME).describedAs(NESTED_COMPONENT_DESCRIPTION);
        return constructDeclarer;
    }

    private void declareGetValuesFromConfig(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer getValuesFromConfigDeclarer = (OperationDeclarer)extensionDeclarer.withOperation(GET_VALUES_FROM_CONFIG).describedAs(GET_VALUES_FROM_CONFIG_DESCRIPTION);
        getValuesFromConfigDeclarer.withOutput().ofType(this.typeLoader.load(ValuesAdapter.class));
        getValuesFromConfigDeclarer.withOutputAttributes().ofType((MetadataType)this.typeBuilder.nullType().build());
        getValuesFromConfigDeclarer.onDefaultParameterGroup().withRequiredParameter(TOOLING_PARAMETER).describedAs(TOOLING_PARAMETER_DESCRIPTION).ofType((MetadataType)this.typeBuilder.stringType().build());
        getValuesFromConfigDeclarer.onDefaultParameterGroup().withRequiredParameter("config-ref").describedAs(GET_VALUES_FROM_CONFIG_REF_DESCRIPTION).withDsl(ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowsReferences(true).build()).withAllowedStereotypes(Collections.singletonList(MuleStereotypes.CONFIG)).ofType((MetadataType)this.typeBuilder.anyType().build()).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void declareProcessors(ExtensionDeclarer extensionDeclarer) {
        this.declareAssertType(extensionDeclarer);
        this.declareTestConnectivity(extensionDeclarer);
    }

    private void declareAssertType(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer operationDeclarer = (OperationDeclarer)extensionDeclarer.withOperation(ASSERT_TYPE_PROCESSOR).describedAs(ASSERT_TYPE_PROCESSOR_DESCRIPTION);
        operationDeclarer.withOutput().ofType((MetadataType)this.typeBuilder.voidType().build());
        operationDeclarer.withOutputAttributes().ofType((MetadataType)this.typeBuilder.nullType().build());
        ParameterGroupDeclarer parameterGroupDeclarer = operationDeclarer.onDefaultParameterGroup();
        ((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(ACTUAL_PARAMETER).describedAs(ACTUAL_PARAMETER_DESCRIPTION)).ofType((MetadataType)this.typeBuilder.stringType().build());
        ((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(FROM_CLASS_PARAMETER).describedAs(FROM_CLASS_PARAMETER_DESCRIPTION)).ofType((MetadataType)this.typeBuilder.stringType().build());
        ((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter(FROM_SCHEMA_PARAMETER).describedAs(FROM_SCHEMA_PARAMETER_DESCRIPTION)).ofType((MetadataType)this.typeBuilder.stringType().build());
        parameterGroupDeclarer.withExclusiveOptionals((Set)Sets.newHashSet((Object[])new String[]{FROM_CLASS_PARAMETER, FROM_SCHEMA_PARAMETER}), true);
    }

    private void declareTestConnectivity(ExtensionDeclarer extensionDeclarer) {
        OperationDeclarer operationDeclarer = (OperationDeclarer)extensionDeclarer.withOperation(TEST_CONNECTIVITY_NAME).describedAs(TEST_CONNECTIVITY_DESCRIPTION);
        operationDeclarer.withOutput().ofType((MetadataType)this.typeBuilder.voidType().build());
        operationDeclarer.withOutputAttributes().ofType((MetadataType)this.typeBuilder.nullType().build());
        ParameterGroupDeclarer parameterGroupDeclarer = operationDeclarer.onDefaultParameterGroup();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("config-ref").describedAs(CONFIG_REF_DESCRIPTION)).withAllowedStereotypes(Collections.singletonList(MuleStereotypes.CONFIG))).ofType((MetadataType)this.typeBuilder.stringType().build());
    }

    private OptionalParameterDeclarer addOptionalParameter(String name, String description, Class<?> clazz, ParameterGroupDeclarer declarer) {
        return this.addOptionalParameter(name, description, this.typeLoader.load(clazz), declarer);
    }

    private OptionalParameterDeclarer addOptionalParameter(String name, String description, MetadataType type, ParameterGroupDeclarer declarer) {
        return (OptionalParameterDeclarer)((OptionalParameterDeclarer)declarer.withOptionalParameter(name).describedAs(description)).ofType(type);
    }
}

