/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.api.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.munit.mtf.tools.api.config.MtfComponentBuildingDefinitionProvider;
import org.mule.munit.mtf.tools.internal.connection.TestConnectivityProcessor;
import org.mule.munit.mtf.tools.internal.tooling.ToolingTest;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.AttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.SetterAttributeDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class MtfComponentBuildingDefinitionProviderTest {
    private MtfComponentBuildingDefinitionProvider provider;
    private List<ComponentBuildingDefinition> definitions;

    @Before
    public void setUp() {
        this.provider = new MtfComponentBuildingDefinitionProvider();
        this.definitions = this.provider.getComponentBuildingDefinitions();
    }

    @Test
    public void isToolingTestDefinitionValid() {
        Class<ToolingTest> typeClass = ToolingTest.class;
        String definitionIdentifierName = "tooling-test";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("name");
        setterParameterNames.add("ignore");
        setterParameterNames.add("description");
        setterParameterNames.add("expectFailureCode");
        setterParameterNames.add("expectFailureMessage");
        setterParameterNames.add("tags");
        setterParameterNames.add("toolingComponent");
        setterParameterNames.add("validation");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isTestConnectivityProcessorDefinitionValid() {
        Class<TestConnectivityProcessor> typeClass = TestConnectivityProcessor.class;
        String definitionIdentifierName = "test-connectivity";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("config");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, false, typeClass, setterParameterNames, constructorParameterNames);
    }

    @Test
    public void isValidationDefinitionValid() {
        Class<MessageProcessorChain> typeClass = MessageProcessorChain.class;
        String definitionIdentifierName = "validation";
        ArrayList<String> constructorParameterNames = new ArrayList<String>();
        ArrayList<String> setterParameterNames = new ArrayList<String>();
        setterParameterNames.add("messageProcessors");
        ComponentBuildingDefinition definition = this.findDefinition(definitionIdentifierName);
        this.assertDefinition(definition, definitionIdentifierName, true, typeClass, setterParameterNames, constructorParameterNames);
    }

    private void assertDefinition(ComponentBuildingDefinition definition, String definitionIdentifierName, Boolean isPrototype, Class typeClass, List<String> setterParameterNames, List<String> constructorParameterNames) {
        Assert.assertNotNull((String)("The " + definitionIdentifierName + " should not be null"), (Object)definition);
        Assert.assertEquals((String)"The definition scope is wrong", (Object)isPrototype, (Object)definition.isPrototype());
        definition.getTypeDefinition().visit((TypeDefinitionVisitor)new TypeAssertionVisitor(typeClass));
        this.assertConstructorParametersNames(definition, constructorParameterNames);
        this.assertSetterParametersNames(definition, setterParameterNames);
    }

    private ComponentBuildingDefinition findDefinition(String identifierName) {
        for (ComponentBuildingDefinition d : this.definitions) {
            if (!"mtf".equals(d.getComponentIdentifier().getNamespace()) || !identifierName.equals(d.getComponentIdentifier().getName())) continue;
            return d;
        }
        return null;
    }

    private void assertSetterParametersNames(ComponentBuildingDefinition definition, List<String> expectedNames) {
        Assert.assertEquals((String)"There number of setter parameters is wrong", (long)expectedNames.size(), (long)definition.getSetterParameterDefinitions().size());
        definition.getSetterParameterDefinitions().forEach(p -> Assert.assertThat((String)("The parameter " + ((SetterAttributeDefinition)p).getAttributeName() + " is invalid"), (Object)expectedNames.contains(((SetterAttributeDefinition)p).getAttributeName()), (Matcher)Matchers.is((Object)true)));
    }

    private void assertConstructorParametersNames(ComponentBuildingDefinition definition, List<String> expectedNames) {
        Assert.assertThat((String)"The number of constructor parameters is wrong", (Object)definition.getConstructorAttributeDefinition().size(), (Matcher)Matchers.is((Object)expectedNames.size()));
        AttributeDefinitionAssertionVisitor visitor = new AttributeDefinitionAssertionVisitor(expectedNames);
        definition.getConstructorAttributeDefinition().forEach(cp -> ((AttributeDefinition)cp).accept((AttributeDefinitionVisitor)visitor));
    }

    private static class AttributeDefinitionAssertionVisitor
    implements AttributeDefinitionVisitor {
        private List<String> attributeNames;

        public AttributeDefinitionAssertionVisitor(List<String> attributeNames) {
            this.attributeNames = attributeNames;
        }

        public void onReferenceObject(Class<?> aClass) {
        }

        public void onReferenceSimpleParameter(String s) {
        }

        public void onSoftReferenceSimpleParameter(String s) {
        }

        public void onReferenceFixedParameter(String s) {
        }

        public void onFixedValue(Object o) {
        }

        public void onConfigurationParameter(String s, Object o, Optional<TypeConverter> optional) {
            Assert.assertThat((String)("The attribute " + s + " is not expected"), (Object)this.attributeNames.contains(s), (Matcher)Matchers.is((Object)true));
        }

        public void onReferenceConfigurationParameter(String s, Object o, Optional<TypeConverter> optional) {
        }

        public void onUndefinedSimpleParameters() {
        }

        public void onUndefinedComplexParameters() {
        }

        public void onComplexChildCollection(Class<?> aClass, Optional<String> optional) {
        }

        public void onComplexChildMap(Class<?> aClass, Class<?> aClass1, String s) {
        }

        public void onComplexChild(Class<?> aClass, Optional<String> optional, Optional<String> optional1) {
        }

        public void onValueFromTextContent() {
        }

        public void onMultipleValues(KeyAttributeDefinitionPair[] keyAttributeDefinitionPairs) {
        }
    }

    private static class TypeAssertionVisitor
    implements TypeDefinitionVisitor {
        private Class<?> clazz;

        public TypeAssertionVisitor(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void onType(Class<?> type) {
            Assert.assertEquals((String)"The type definition is wrong classes do not match.", this.clazz, type);
        }

        public void onConfigurationAttribute(String s, Class<?> aClass) {
        }

        public void onMapType(TypeDefinition.MapEntryType mapEntryType) {
        }
    }
}

