/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.connection;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.munit.mtf.tools.internal.connection.TestConnectivityProcessor;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

public class TestConnectivityProcessorTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private TestConnectivityProcessor testConnectivityProcessor;
    private PrivilegedMuleContext muleContext;
    private CoreEvent inputEvent;
    private ConnectionManager connectionManagerMock;
    private ConfigurationInstance configurationInstanceMock;
    private ErrorTypeRepository errorTypeRepository;

    @Before
    public void setUp() throws Exception {
        EventContext eventContextMock = (EventContext)Mockito.mock(BaseEventContext.class);
        ConfigurationProvider configurationProviderMock = (ConfigurationProvider)Mockito.mock(ConfigurationProvider.class);
        this.errorTypeRepository = ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository();
        this.connectionManagerMock = (ConnectionManager)Mockito.mock(ConnectionManager.class);
        this.muleContext = (PrivilegedMuleContext)Mockito.mock(PrivilegedMuleContext.class);
        this.configurationInstanceMock = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
        this.inputEvent = CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"")).build();
        Mockito.when((Object)this.muleContext.getErrorTypeRepository()).thenReturn((Object)this.errorTypeRepository);
        Mockito.when((Object)configurationProviderMock.get((Event)this.inputEvent)).thenReturn((Object)this.configurationInstanceMock);
        this.testConnectivityProcessor = new TestConnectivityProcessor();
        this.testConnectivityProcessor.setMuleContext((MuleContext)this.muleContext);
        this.testConnectivityProcessor.lazyConnectionManager = new TestConnectionManager(this.connectionManagerMock);
        this.testConnectivityProcessor.initialise();
        this.testConnectivityProcessor.setConfig(configurationProviderMock);
    }

    @Test(expected=InitialisationException.class)
    public void noDelegateInConnectionManager() throws InitialisationException {
        this.testConnectivityProcessor.lazyConnectionManager = new DefaultConnectionManager((MuleContext)this.muleContext);
        this.testConnectivityProcessor.initialise();
    }

    @Test
    public void successfulConnectionReturnsSameEvent() {
        Mockito.when((Object)this.connectionManagerMock.testConnectivity(this.configurationInstanceMock)).thenReturn((Object)ConnectionValidationResult.success());
        CoreEvent resultEvent = this.testConnectivityProcessor.process(this.inputEvent);
        MatcherAssert.assertThat((Object)resultEvent, (Matcher)IsEqual.equalTo((Object)this.inputEvent));
    }

    @Test
    public void failureWithConnectionWithoutCause() {
        String errorDescription = "A connection problem";
        ConnectionException connectionException = new ConnectionException("A problem in the connection");
        Mockito.when((Object)this.connectionManagerMock.testConnectivity(this.configurationInstanceMock)).thenReturn((Object)ConnectionValidationResult.failure((String)errorDescription, (Exception)connectionException));
        try {
            this.testConnectivityProcessor.process(this.inputEvent);
            Assert.fail((String)"Processor should have failed");
        }
        catch (TypedException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)IsEqual.equalTo((Object)errorDescription));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)IsEqual.equalTo((Object)connectionException));
        }
    }

    @Test
    public void failureWithConnectionWithCause() {
        String errorDescription = "A connection problem";
        IllegalArgumentException cause = new IllegalArgumentException("Invalid credentials");
        Mockito.when((Object)this.connectionManagerMock.testConnectivity(this.configurationInstanceMock)).thenReturn((Object)ConnectionValidationResult.failure((String)errorDescription, (Exception)new ConnectionException((Throwable)cause)));
        try {
            this.testConnectivityProcessor.process(this.inputEvent);
            Assert.fail((String)"Processor should have failed");
        }
        catch (TypedException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)IsEqual.equalTo((Object)errorDescription));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)IsEqual.equalTo((Object)cause));
        }
    }

    @Test
    public void failureWithErrorType() {
        String errorDescription = "A connection problem";
        ConnectionException connectionException = new ConnectionException("A connection exception");
        ErrorType errorType = (ErrorType)this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY).get();
        Mockito.when((Object)this.connectionManagerMock.testConnectivity(this.configurationInstanceMock)).thenReturn((Object)ConnectionValidationResult.failure((String)errorDescription, (ErrorType)errorType, (Exception)connectionException));
        try {
            this.testConnectivityProcessor.process(this.inputEvent);
            Assert.fail((String)"Processor should have failed");
        }
        catch (TypedException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)IsEqual.equalTo((Object)errorDescription));
            MatcherAssert.assertThat((Object)e.getErrorType(), (Matcher)IsEqual.equalTo((Object)errorType));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)IsEqual.equalTo((Object)connectionException));
        }
    }

    private static class TestConnectionManager
    implements ConnectionManager {
        private ConnectionManager delegate;

        TestConnectionManager(ConnectionManager delegate) {
            this.delegate = delegate;
        }

        public <C> void bind(Object config, ConnectionProvider<C> connectionProvider) {
            this.delegate.bind(config, connectionProvider);
        }

        public boolean hasBinding(Object config) {
            return this.delegate.hasBinding(config);
        }

        public void unbind(Object config) {
            this.delegate.unbind(config);
        }

        public <C> ConnectionHandler<C> getConnection(Object config) throws ConnectionException {
            return this.delegate.getConnection(config);
        }

        public <C> ConnectionValidationResult testConnectivity(ConnectionProvider<C> connectionProvider) {
            return this.delegate.testConnectivity(connectionProvider);
        }

        public <C> ConnectionValidationResult testConnectivity(C connection, ConnectionHandler<C> connectionHandler) {
            return this.delegate.testConnectivity(connection, connectionHandler);
        }

        public ConnectionValidationResult testConnectivity(ConfigurationInstance configurationInstance) throws IllegalArgumentException {
            return this.delegate.testConnectivity(configurationInstance);
        }
    }
}

