/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.munit.mtf.tools.internal.tooling.AbstractToolingScope;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class AbstractToolingScopeTest {
    private static final String EXAMPLE_TOOLING_INFORMATION = "EXAMPLE_TOOLING_INFO";
    private Component componentMock;
    private AbstractToolingScope toolingScope;

    @Before
    public void setUp() {
        this.componentMock = (Component)Mockito.mock(Component.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class}));
        this.toolingScope = new TestToolingScope();
        this.toolingScope.setComponent(this.componentMock);
        PrivilegedMuleContext muleContextMock = (PrivilegedMuleContext)Mockito.mock(PrivilegedMuleContext.class);
        Injector injectorMock = (Injector)Mockito.mock(Injector.class);
        Mockito.when((Object)muleContextMock.getInjector()).thenReturn((Object)injectorMock);
        this.toolingScope.muleContext = muleContextMock;
    }

    @Test
    public void toolingMessage() throws ToolingTestException {
        BaseEventContext eventContextMock = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        CoreEvent incomingEvent = CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"incomingPayload")).build();
        CoreEvent resultEvent = this.toolingScope.process(incomingEvent);
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)IsEqual.equalTo((Object)EXAMPLE_TOOLING_INFORMATION));
    }

    @Test
    public void initialise() throws Exception {
        this.toolingScope.initialise();
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.componentMock))).initialise();
    }

    @Test
    public void dispose() {
        this.toolingScope.dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.componentMock))).dispose();
    }

    private static class TestToolingScope
    extends AbstractToolingScope {
        private TestToolingScope() {
        }

        public Message getMessage() {
            return Message.of((Object)AbstractToolingScopeTest.EXAMPLE_TOOLING_INFORMATION);
        }
    }
}

