/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.munit.mtf.tools.internal.tooling.AbstractToolingScope;
import org.mule.munit.mtf.tools.internal.tooling.ToolingComponent;
import org.mule.munit.mtf.tools.internal.tooling.ToolingTest;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;

public class ToolingTestTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ToolingTest toolingTest = new ToolingTest();
    private ToolingComponent toolingComponentMock;
    private MessageProcessorChain validationMock;

    @Before
    public void setUp() {
        this.toolingTest = new ToolingTest();
        PrivilegedMuleContext muleContextMock = (PrivilegedMuleContext)Mockito.mock(PrivilegedMuleContext.class);
        Injector injectorMock = (Injector)Mockito.mock(Injector.class);
        Mockito.when((Object)muleContextMock.getInjector()).thenReturn((Object)injectorMock);
        this.toolingTest.muleContext = muleContextMock;
        this.toolingComponentMock = (ToolingComponent)Mockito.mock(AbstractToolingScope.class);
        this.validationMock = (MessageProcessorChain)Mockito.mock(MessageProcessorChain.class);
        this.toolingTest.setToolingComponent(this.toolingComponentMock);
        this.toolingTest.setValidation(this.validationMock);
    }

    @Test
    public void processScopeResult() throws Throwable {
        CoreEvent inputEvent = this.createInputEvent();
        CoreEvent resultEventMock = CoreEvent.builder((CoreEvent)inputEvent).build();
        Mockito.when((Object)this.toolingComponentMock.process(inputEvent)).thenReturn((Object)resultEventMock);
        this.toolingTest.run((Event)inputEvent);
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).process(resultEventMock);
    }

    @Test
    public void expectFailureMessageButNotFail() throws Throwable {
        String failureMessage = "A failureMessage";
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Test was expecting to fail with the message: " + failureMessage);
        CoreEvent inputEvent = this.createInputEvent();
        this.toolingTest.setExpectFailureMessage(failureMessage);
        this.toolingTest.run((Event)inputEvent);
    }

    @Test
    public void expectFailureCodeButNotFail() throws Throwable {
        String failureCode = FailureCode.INVALID_METADATA_KEY.getName();
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Test was expecting to fail with the failure code: " + failureCode);
        CoreEvent inputEvent = this.createInputEvent();
        this.toolingTest.setExpectFailureCode(failureCode);
        this.toolingTest.run((Event)inputEvent);
    }

    @Test
    public void expectFailureCodeAndMessageButNotFail() throws Throwable {
        String failureCode = FailureCode.INVALID_METADATA_KEY.getName();
        String failureMessage = "A failureMessage";
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Test was expecting to fail with the failure code: " + failureCode + " and with the message: " + failureMessage);
        CoreEvent inputEvent = this.createInputEvent();
        this.toolingTest.setExpectFailureCode(failureCode);
        this.toolingTest.setExpectFailureMessage(failureMessage);
        this.toolingTest.run((Event)inputEvent);
    }

    @Test
    public void expectFailureCode() throws Throwable {
        FailureCode failureCode = FailureCode.INVALID_METADATA_KEY;
        CoreEvent inputEvent = this.createInputEvent();
        Mockito.when((Object)this.toolingComponentMock.process(inputEvent)).thenThrow(new Throwable[]{new ToolingTestException("", failureCode.getName(), "")});
        this.toolingTest.setExpectFailureCode(failureCode.getName());
        this.toolingTest.run((Event)inputEvent);
    }

    @Test
    public void unexpectedFailureCode() throws Throwable {
        CoreEvent inputEvent = this.createInputEvent();
        FailureCode actualCode = FailureCode.CONNECTION_FAILURE;
        FailureCode expectedCode = FailureCode.INVALID_METADATA_KEY;
        Mockito.when((Object)this.toolingComponentMock.process(inputEvent)).thenThrow(new Throwable[]{new ToolingTestException("", actualCode.getName(), "")});
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Expected failure code [" + expectedCode + "] but was [" + actualCode + "]");
        this.toolingTest.setExpectFailureCode(expectedCode.getName());
        this.toolingTest.run((Event)inputEvent);
    }

    @Test
    public void expectFailureMessage() throws Throwable {
        String failureMessage = "A message";
        CoreEvent inputEvent = this.createInputEvent();
        CoreEvent resultEventMock = CoreEvent.builder((CoreEvent)inputEvent).build();
        Mockito.when((Object)this.toolingComponentMock.process(inputEvent)).thenThrow(new Throwable[]{new ToolingTestException(failureMessage, "", "")});
        this.toolingTest.setExpectFailureMessage(failureMessage);
        this.toolingTest.run((Event)inputEvent);
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).process(resultEventMock);
    }

    @Test
    public void unexpectedFailureMessage() throws Throwable {
        CoreEvent inputEvent = this.createInputEvent();
        CoreEvent resultEventMock = CoreEvent.builder((CoreEvent)inputEvent).build();
        String expectedMessage = "A message";
        String actualMessage = "Another message";
        Mockito.when((Object)this.toolingComponentMock.process(inputEvent)).thenThrow(new Throwable[]{new ToolingTestException(actualMessage, "", "")});
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Expected error message [" + expectedMessage + "] but was [" + actualMessage + "]");
        this.toolingTest.setExpectFailureMessage(expectedMessage);
        this.toolingTest.run((Event)inputEvent);
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).process(resultEventMock);
    }

    @Test
    public void unexpectedFailureMessageAndCode() throws Throwable {
        CoreEvent inputEvent = this.createInputEvent();
        CoreEvent resultEventMock = CoreEvent.builder((CoreEvent)inputEvent).build();
        String actualMessage = "Another message";
        String expectedMessage = "A message";
        FailureCode expectedCode = FailureCode.INVALID_METADATA_KEY;
        String actualCode = FailureCode.CONNECTION_FAILURE.getName();
        Mockito.when((Object)this.toolingComponentMock.process(inputEvent)).thenThrow(new Throwable[]{new ToolingTestException(actualMessage, actualCode, "")});
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Expected failure code [" + expectedCode + "] but was [" + actualCode + "] and error message [" + expectedMessage + "] but was [" + actualMessage + "]");
        this.toolingTest.setExpectFailureMessage(expectedMessage);
        this.toolingTest.setExpectFailureCode(expectedCode.getName());
        this.toolingTest.run((Event)inputEvent);
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).process(resultEventMock);
    }

    @Test(expected=ToolingTestException.class)
    public void failsWithToolingTestException() throws Throwable {
        CoreEvent inputEvent = this.createInputEvent();
        CoreEvent resultEventMock = CoreEvent.builder((CoreEvent)inputEvent).build();
        Mockito.when((Object)this.toolingComponentMock.process(inputEvent)).thenThrow(new Throwable[]{new ToolingTestException("A message", "", "")});
        this.toolingTest.run((Event)inputEvent);
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).process(resultEventMock);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidTag() {
        String tagParameter = "NO_TAG,other";
        this.toolingTest.setTags(tagParameter);
        this.toolingTest.getTags();
    }

    @Test
    public void tags() {
        String firstTag = "first";
        String secondTag = "second";
        String tagParameter = firstTag + "," + secondTag;
        this.toolingTest.setTags(tagParameter);
        MatcherAssert.assertThat((Object)this.toolingTest.getTags(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{firstTag, secondTag}));
    }

    @Test
    public void initialise() throws Exception {
        this.toolingTest.initialise();
        ((ToolingComponent)Mockito.verify((Object)this.toolingComponentMock)).initialise();
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).initialise();
    }

    @Test
    public void start() throws Exception {
        this.toolingTest.start();
        ((ToolingComponent)Mockito.verify((Object)this.toolingComponentMock)).start();
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).start();
    }

    @Test
    public void stop() throws Exception {
        this.toolingTest.stop();
        ((ToolingComponent)Mockito.verify((Object)this.toolingComponentMock)).stop();
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).stop();
    }

    @Test
    public void dispose() throws Exception {
        this.toolingTest.dispose();
        ((ToolingComponent)Mockito.verify((Object)this.toolingComponentMock)).dispose();
        ((MessageProcessorChain)Mockito.verify((Object)this.validationMock)).dispose();
    }

    private CoreEvent createInputEvent() {
        BaseEventContext eventContextMock = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        return CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"inputPayload")).build();
    }
}

