/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.api.JsonMetadataTypeWriterFactory;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.metadata.GetInputMetadataScope;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.UnexpectedMetadataFailureException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import util.ToolingTestUtils;

public class GetInputMetadataScopeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String A_PARAMETER = "aParameter";
    private GetInputMetadataScope getInputMetadataScope;
    private MetadataService metadataServiceMock;
    private CoreEvent inputEvent;
    private Component operationMock;
    private Component sourceMock;
    private Location location;

    @Before
    public void setUp() {
        this.getInputMetadataScope = new GetInputMetadataScope();
        this.getInputMetadataScope.setParameter(A_PARAMETER);
        this.metadataServiceMock = (MetadataService)Mockito.mock(MetadataService.class);
        BaseEventContext eventContextMock = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        this.inputEvent = CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"incomingPayload")).build();
        this.operationMock = (Component)Mockito.mock(Component.class);
        this.sourceMock = (Component)Mockito.mock(MessageSource.class);
        DefaultComponentLocation componentLocation = new DefaultComponentLocation(Optional.of("component"), Collections.emptyList());
        this.location = Location.builderFromStringRepresentation((String)componentLocation.getLocation()).build();
        Mockito.when((Object)this.operationMock.getLocation()).thenReturn((Object)componentLocation);
        Mockito.when((Object)this.sourceMock.getLocation()).thenReturn((Object)componentLocation);
        this.getInputMetadataScope.metadataService = this.metadataServiceMock;
        this.getInputMetadataScope.setComponent(this.operationMock);
    }

    @Test
    public void failureInOperationMetadata() throws Exception {
        MetadataFailure metadataFailure = ToolingTestUtils.newMetadataFailure().onParameter(A_PARAMETER);
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure});
        Mockito.when((Object)this.metadataServiceMock.getOperationMetadata(this.location)).thenReturn((Object)failure);
        try {
            this.getInputMetadataScope.process(this.inputEvent);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (ToolingTestException metadataException) {
            MatcherAssert.assertThat((Object)metadataException.getFailureMessage(), (Matcher)Matchers.equalTo((Object)metadataFailure.getMessage()));
            MatcherAssert.assertThat((Object)metadataException.getFailureCode(), (Matcher)Matchers.equalTo((Object)metadataFailure.getFailureCode().getName()));
            MatcherAssert.assertThat((Object)metadataException.getReason(), (Matcher)Matchers.equalTo((Object)metadataFailure.getReason()));
        }
    }

    @Test
    public void failureInSourceMetadata() throws Exception {
        this.getInputMetadataScope.setComponent(this.sourceMock);
        MetadataFailure metadataFailure = ToolingTestUtils.newMetadataFailure().onParameter(A_PARAMETER);
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure});
        Mockito.when((Object)this.metadataServiceMock.getSourceMetadata(this.location)).thenReturn((Object)failure);
        try {
            this.getInputMetadataScope.process(this.inputEvent);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (ToolingTestException metadataException) {
            MatcherAssert.assertThat((Object)metadataException.getFailureMessage(), (Matcher)Matchers.equalTo((Object)metadataFailure.getMessage()));
            MatcherAssert.assertThat((Object)metadataException.getFailureCode(), (Matcher)Matchers.equalTo((Object)metadataFailure.getFailureCode().getName()));
            MatcherAssert.assertThat((Object)metadataException.getReason(), (Matcher)Matchers.equalTo((Object)metadataFailure.getReason()));
        }
    }

    @Test
    public void failureWithAnotherComponent() throws Exception {
        this.thrown.expect(UnexpectedMetadataFailureException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"An unexpected metadata failure occurred: Expected a failure of component [INPUT] but got the following failures from other components: "));
        MetadataFailure metadataFailure = ToolingTestUtils.newMetadataFailure().onOutputAttributes();
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure});
        Mockito.when((Object)this.metadataServiceMock.getOperationMetadata(this.location)).thenReturn((Object)failure);
        this.getInputMetadataScope.process(this.inputEvent);
    }

    @Test
    public void inputMetadataSuccess() throws Exception {
        this.getInputMetadataScope.metadataTypeWriter = JsonMetadataTypeWriterFactory.create();
        MetadataFormat format = MetadataFormat.JAVA;
        ImmutableParameterModel parameterModel = new ImmutableParameterModel(A_PARAMETER, "aDescription", (MetadataType)new BaseTypeBuilder(format).stringType().build(), false, true, false, ExpressionSupport.NOT_SUPPORTED, null, ParameterRole.CONTENT, ParameterDslConfiguration.builder().build(), DisplayModel.builder().build(), LayoutModel.builder().build(), null, Collections.emptyList(), Collections.emptySet());
        MetadataResult metadataResult = MetadataResult.success((Object)ComponentMetadataDescriptor.builder((ComponentModel)this.getOperationModel((ParameterModel)parameterModel)).build());
        Mockito.when((Object)this.metadataServiceMock.getOperationMetadata(this.location)).thenReturn((Object)metadataResult);
        CoreEvent resultEvent = this.getInputMetadataScope.process(this.inputEvent);
        Map jsonMetadataType = (Map)new Gson().fromJson((String)resultEvent.getMessage().getPayload().getValue(), Map.class);
        MatcherAssert.assertThat(jsonMetadataType.get("format"), (Matcher)Matchers.equalTo((Object)format.getId()));
        MatcherAssert.assertThat(jsonMetadataType.get("type"), (Matcher)Matchers.equalTo((Object)"String"));
    }

    private ImmutableOperationModel getOperationModel(ParameterModel parameterModel) {
        DisplayModel displayModel = DisplayModel.builder().displayName("aDisplayName").build();
        ImmutableParameterGroupModel parameterGroupModel = new ImmutableParameterGroupModel("aParameterGroup", "aDescription", Collections.singletonList(parameterModel), Collections.emptyList(), false, displayModel, LayoutModel.builder().build(), Collections.emptySet());
        return new ImmutableOperationModel("aName", "aDescription", Collections.singletonList(parameterGroupModel), Collections.emptyList(), (OutputModel)Mockito.mock(OutputModel.class), (OutputModel)Mockito.mock(OutputModel.class), true, ExecutionType.BLOCKING, false, false, false, displayModel, Collections.emptySet(), StereotypeModelBuilder.newStereotype((String)"aType", (String)"example").build(), Collections.emptySet(), Collections.emptySet());
    }
}

