/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.metadata.GetMetadataKeysScope;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.UnexpectedMetadataFailureException;
import org.mule.munit.mtf.tools.internal.tooling.metadata.model.MetadataKeyAdapter;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import util.ToolingTestUtils;

public class GetMetadataKeysScopeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private GetMetadataKeysScope getMetadataKeysScope;
    private MetadataService metadataServiceMock;
    private CoreEvent inputEvent;
    private Component componentMock;
    private Location location;

    @Before
    public void setUp() {
        this.getMetadataKeysScope = new GetMetadataKeysScope();
        this.metadataServiceMock = (MetadataService)Mockito.mock(MetadataService.class);
        BaseEventContext eventContextMock = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        this.inputEvent = CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"incomingPayload")).build();
        this.componentMock = (Component)Mockito.mock(Component.class);
        DefaultComponentLocation componentLocation = new DefaultComponentLocation(Optional.of("component"), Collections.emptyList());
        this.location = Location.builderFromStringRepresentation((String)componentLocation.getLocation()).build();
        Mockito.when((Object)this.componentMock.getLocation()).thenReturn((Object)componentLocation);
        this.getMetadataKeysScope.metadataService = this.metadataServiceMock;
        this.getMetadataKeysScope.setComponent(this.componentMock);
    }

    @Test
    public void failuresInKeysMetadataResult() throws Exception {
        MetadataFailure metadataFailure = ToolingTestUtils.newMetadataFailure().onKeys();
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure});
        Mockito.when((Object)this.metadataServiceMock.getMetadataKeys(this.location)).thenReturn((Object)failure);
        try {
            this.getMetadataKeysScope.process(this.inputEvent);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (ToolingTestException metadataException) {
            MatcherAssert.assertThat((Object)metadataException.getFailureMessage(), (Matcher)Matchers.equalTo((Object)metadataFailure.getMessage()));
            MatcherAssert.assertThat((Object)metadataException.getFailureCode(), (Matcher)Matchers.equalTo((Object)metadataFailure.getFailureCode().getName()));
            MatcherAssert.assertThat((Object)metadataException.getReason(), (Matcher)Matchers.equalTo((Object)metadataFailure.getReason()));
        }
    }

    @Test
    public void failureWithAnotherComponent() throws Exception {
        this.thrown.expect(UnexpectedMetadataFailureException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"An unexpected metadata failure occurred: Expected a failure of component [KEYS] but got the following failures from other components: "));
        MetadataFailure metadataFailure = MetadataFailure.Builder.newFailure().onOutputAttributes();
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure});
        Mockito.when((Object)this.metadataServiceMock.getMetadataKeys(this.location)).thenReturn((Object)failure);
        this.getMetadataKeysScope.process(this.inputEvent);
    }

    @Test
    public void failureIfMoreThanOneCategory() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to get metadata keys: Number of categories should be only one");
        MetadataKeysContainer metadataKeysContainer = (MetadataKeysContainer)Mockito.mock(MetadataKeysContainer.class);
        MetadataKey aKey = MetadataKeyBuilder.newKey((String)"aKey").build();
        Mockito.when((Object)metadataKeysContainer.getKeysByCategory()).thenReturn((Object)ImmutableMap.of((Object)"aCategory", (Object)Sets.newHashSet((Object[])new MetadataKey[]{aKey}), (Object)"anotherCategory", Collections.emptySet()));
        MetadataResult failure = MetadataResult.success((Object)metadataKeysContainer);
        Mockito.when((Object)this.metadataServiceMock.getMetadataKeys(this.location)).thenReturn((Object)failure);
        this.getMetadataKeysScope.process(this.inputEvent);
    }

    @Test
    public void metadataSuccess() throws Exception {
        MetadataKeysContainer metadataKeysContainer = (MetadataKeysContainer)Mockito.mock(MetadataKeysContainer.class);
        MetadataKey aKey = MetadataKeyBuilder.newKey((String)"aKey").build();
        Mockito.when((Object)metadataKeysContainer.getKeysByCategory()).thenReturn((Object)ImmutableMap.of((Object)"aCategory", (Object)Sets.newHashSet((Object[])new MetadataKey[]{aKey})));
        MetadataResult failure = MetadataResult.success((Object)metadataKeysContainer);
        Mockito.when((Object)this.metadataServiceMock.getMetadataKeys(this.location)).thenReturn((Object)failure);
        CoreEvent resultEvent = this.getMetadataKeysScope.process(this.inputEvent);
        Map metadataKeys = (Map)resultEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)metadataKeys.containsKey(aKey.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat(metadataKeys.get(aKey.getId()), (Matcher)Matchers.instanceOf(MetadataKeyAdapter.class));
        MatcherAssert.assertThat((Object)((MetadataKeyAdapter)metadataKeys.get(aKey.getId())).getId(), (Matcher)Matchers.equalTo((Object)aKey.getId()));
        MatcherAssert.assertThat((Object)((MetadataKeyAdapter)metadataKeys.get(aKey.getDisplayName())).getId(), (Matcher)Matchers.equalTo((Object)aKey.getDisplayName()));
    }
}

