/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.api.JsonMetadataTypeWriterFactory;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.metadata.GetOutputMetadataScope;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.UnexpectedMetadataFailureException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import util.ToolingTestUtils;

public class GetOutputMetadataScopeTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private GetOutputMetadataScope getOutputMetadataScope;
    private MetadataService metadataServiceMock;
    private CoreEvent inputEvent;
    private Component operationMock;
    private Component sourceMock;
    private Location location;

    @Before
    public void setUp() {
        this.getOutputMetadataScope = new GetOutputMetadataScope();
        this.metadataServiceMock = (MetadataService)Mockito.mock(MetadataService.class);
        BaseEventContext eventContextMock = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        this.inputEvent = CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"incomingPayload")).build();
        this.operationMock = (Component)Mockito.mock(Component.class);
        this.sourceMock = (Component)Mockito.mock(MessageSource.class);
        DefaultComponentLocation componentLocation = new DefaultComponentLocation(Optional.of("component"), Collections.emptyList());
        this.location = Location.builderFromStringRepresentation((String)componentLocation.getLocation()).build();
        Mockito.when((Object)this.operationMock.getLocation()).thenReturn((Object)componentLocation);
        Mockito.when((Object)this.sourceMock.getLocation()).thenReturn((Object)componentLocation);
        this.getOutputMetadataScope.metadataService = this.metadataServiceMock;
        this.getOutputMetadataScope.setComponent(this.operationMock);
    }

    @Test
    public void failureInOperationMetadata() throws Exception {
        MetadataFailure metadataFailure = ToolingTestUtils.newMetadataFailure().onOutputPayload();
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure});
        Mockito.when((Object)this.metadataServiceMock.getOperationMetadata(this.location)).thenReturn((Object)failure);
        try {
            this.getOutputMetadataScope.process(this.inputEvent);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (ToolingTestException metadataException) {
            this.assertMetadataFailure(metadataException, metadataFailure);
        }
    }

    @Test
    public void failureInSourceMetadata() throws Exception {
        this.getOutputMetadataScope.setComponent(this.sourceMock);
        MetadataFailure metadataFailure = ToolingTestUtils.newMetadataFailure().onOutputPayload();
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure});
        Mockito.when((Object)this.metadataServiceMock.getSourceMetadata(this.location)).thenReturn((Object)failure);
        try {
            this.getOutputMetadataScope.process(this.inputEvent);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (ToolingTestException metadataException) {
            this.assertMetadataFailure(metadataException, metadataFailure);
        }
    }

    @Test
    public void failureWithAnotherComponent() throws Exception {
        this.thrown.expect(UnexpectedMetadataFailureException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"An unexpected metadata failure occurred: Expected a failure of component [OUTPUT_PAYLOAD] but got the following failures from other components: "));
        MetadataFailure metadataFailure = ToolingTestUtils.newMetadataFailure().onOutputAttributes();
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{metadataFailure});
        Mockito.when((Object)this.metadataServiceMock.getOperationMetadata(this.location)).thenReturn((Object)failure);
        this.getOutputMetadataScope.process(this.inputEvent);
    }

    @Test
    public void outputMetadataSuccess() throws Exception {
        this.getOutputMetadataScope.metadataTypeWriter = JsonMetadataTypeWriterFactory.create();
        MetadataFormat format = MetadataFormat.JAVA;
        ImmutableOutputModel outputModel = new ImmutableOutputModel("aDescription", (MetadataType)new BaseTypeBuilder(format).stringType().build(), false, Collections.emptySet());
        MetadataResult metadataResult = MetadataResult.success((Object)ComponentMetadataDescriptor.builder((ComponentModel)this.getOperationModel((OutputModel)outputModel)).build());
        Mockito.when((Object)this.metadataServiceMock.getOperationMetadata(this.location)).thenReturn((Object)metadataResult);
        CoreEvent resultEvent = this.getOutputMetadataScope.process(this.inputEvent);
        Map jsonMetadataType = (Map)new Gson().fromJson((String)resultEvent.getMessage().getPayload().getValue(), Map.class);
        MatcherAssert.assertThat(jsonMetadataType.get("format"), (Matcher)Matchers.equalTo((Object)format.getId()));
        MatcherAssert.assertThat(jsonMetadataType.get("type"), (Matcher)Matchers.equalTo((Object)"String"));
    }

    private ImmutableOperationModel getOperationModel(OutputModel outputModel) {
        return new ImmutableOperationModel("aName", "aDescription", Collections.emptyList(), Collections.emptyList(), outputModel, (OutputModel)Mockito.mock(OutputModel.class), true, ExecutionType.BLOCKING, false, false, false, DisplayModel.builder().displayName("aDisplayName").build(), Collections.emptySet(), StereotypeModelBuilder.newStereotype((String)"aType", (String)"example").build(), Collections.emptySet(), Collections.emptySet());
    }

    private void assertMetadataFailure(ToolingTestException metadataException, MetadataFailure metadataFailure) {
        MatcherAssert.assertThat((Object)metadataException.getFailureMessage(), (Matcher)Matchers.equalTo((Object)metadataFailure.getMessage()));
        MatcherAssert.assertThat((Object)metadataException.getFailureCode(), (Matcher)Matchers.equalTo((Object)metadataFailure.getFailureCode().getName()));
        MatcherAssert.assertThat((Object)metadataException.getReason(), (Matcher)Matchers.equalTo((Object)metadataFailure.getReason()));
    }
}

