/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata.processors;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import model.Animal;
import model.Person;
import org.apache.commons.io.IOUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.persistence.api.JsonMetadataTypeWriterFactory;
import org.mule.metadata.xml.api.ModelFactory;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.munit.mtf.tools.internal.tooling.metadata.processors.AssertTypeProcessor;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;

public class AssertTypeProcessorTest {
    private AssertTypeProcessor assertTypeProcessor;
    private ExpressionManager expressionManagerMock;
    private CoreEvent inputEvent;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.assertTypeProcessor = new AssertTypeProcessor();
        this.assertTypeProcessor.expressionManager = this.expressionManagerMock = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        BaseEventContext eventContextMock = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        this.inputEvent = CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"incomingPayload")).build();
        this.assertTypeProcessor.initialise();
    }

    @Test
    public void noExpectedMetadataTypeDefined() throws MuleException {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("No metadata type to compare was defined. Expected the processor to define one of: [fromClass, fromSchema]");
        this.assertTypeProcessor.process(this.inputEvent);
    }

    @Test
    public void actualNotCoercedToString() throws MuleException {
        this.inputEvent = CoreEvent.builder((CoreEvent)this.inputEvent).message(Message.of((Object)1)).build();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Parameter 'actual' can not be coerced to a String, was of type: java.lang.Integer");
        this.assertTypeProcessor.process(this.inputEvent);
    }

    @Test
    public void expectFromClass() throws MuleException {
        Class<Person> personType = Person.class;
        this.inputEvent = this.createEventWithMetadataType(this.loadTypeFromJava(personType));
        this.assertTypeProcessor.setFromClass(personType.getCanonicalName());
        this.assertTypeProcessor.process(this.inputEvent);
    }

    @Test
    public void expectFromClassFail() throws MuleException {
        Class<Person> personType = Person.class;
        Class<Animal> animalType = Animal.class;
        this.inputEvent = this.createEventWithMetadataType(this.loadTypeFromJava(personType));
        this.assertTypeProcessor.setFromClass(animalType.getCanonicalName());
        this.thrown.expect(AssertionError.class);
        this.thrown.expectMessage("Expected: name");
        this.thrown.expectMessage("got: firstName");
        this.thrown.expectMessage("Expected: owner");
        this.thrown.expectMessage("got: lastName");
        this.assertTypeProcessor.process(this.inputEvent);
    }

    @Test
    public void classNotFoundIsIllegalArgument() throws MuleException {
        Class<Person> personType = Person.class;
        this.inputEvent = this.createEventWithMetadataType(this.loadTypeFromJava(personType));
        this.assertTypeProcessor.setFromClass("non.existent.Class");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Unable to load class non.existent.Class");
        this.assertTypeProcessor.process(this.inputEvent);
    }

    @Test
    public void expectFromXmlSchema() throws Exception {
        this.inputEvent = this.createEventWithMetadataType(this.loadTypeFromXml());
        this.assertTypeProcessor.setFromSchema("person-schema.xsd");
        this.assertTypeProcessor.process(this.inputEvent);
    }

    @Test
    public void expectFromJsonSchema() throws Exception {
        this.inputEvent = this.createEventWithMetadataType(this.loadTypeFromJson());
        this.assertTypeProcessor.setFromSchema("person-schema.json");
        this.assertTypeProcessor.process(this.inputEvent);
    }

    @Test
    public void expectFromClassField() throws Exception {
        MetadataType animalType = this.loadTypeFromJava(Animal.class);
        ObjectFieldType ownerField = (ObjectFieldType)((ObjectType)animalType).getFieldByName("owner").get();
        String actualExpression = "#[payload.fields[0].model]";
        this.inputEvent = this.createEventWithMetadataType(animalType);
        Mockito.when((Object)this.expressionManagerMock.evaluate(actualExpression, this.inputEvent)).thenReturn((Object)TypedValue.of((Object)this.toJson(ownerField.getValue())));
        this.assertTypeProcessor.setActual(actualExpression);
        this.assertTypeProcessor.setFromClass(Person.class.getCanonicalName());
        this.assertTypeProcessor.process(this.inputEvent);
    }

    @Test
    public void expectFromRamlSchema() throws Exception {
        this.inputEvent = this.createEventWithMetadataType(this.loadTypeFromJson());
        this.assertTypeProcessor.setFromSchema("person-type.raml");
        this.assertTypeProcessor.process(this.inputEvent);
    }

    private CoreEvent createEventWithMetadataType(MetadataType metadataType) {
        return CoreEvent.builder((CoreEvent)this.inputEvent).message(Message.of((Object)this.toJson(metadataType))).build();
    }

    private MetadataType loadTypeFromJava(Class clazz) {
        return ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(this.getClass().getClassLoader()).load((Type)clazz);
    }

    private MetadataType loadTypeFromXml() throws IOException {
        String exampleContent = IOUtils.toString((URL)IOUtils.resourceToURL((String)"/person-example.xml"), (Charset)Charset.defaultCharset());
        return (MetadataType)new XmlTypeLoader(ModelFactory.fromExample((String)exampleContent)).load("person").orElseThrow(() -> new AssertionError((Object)"Metadata type should be present"));
    }

    private MetadataType loadTypeFromJson() throws IOException {
        String schemaContent = IOUtils.toString((URL)IOUtils.resourceToURL((String)"/other-person-schema.json"), (Charset)Charset.defaultCharset());
        return (MetadataType)new JsonTypeLoader(schemaContent).load("").orElseThrow(() -> new AssertionError((Object)"Metadata type should be present"));
    }

    private String toJson(MetadataType metadataType) {
        return JsonMetadataTypeWriterFactory.create().toString(metadataType);
    }
}

