/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.values;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.values.GetValuesFromConfig;
import org.mule.munit.mtf.tools.internal.tooling.values.model.ValuesAdapter;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.values.ValueBuilder;
import util.ToolingTestUtils;

public class GetValuesFromConfigTest {
    private static final String A_PARAMETER = "aParam";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private GetValuesFromConfig getValuesFromConfig;
    private ValueProviderService valueProviderServiceMock;
    private CoreEvent inputEvent;
    private Component configMock;
    private Location configLocation;
    private Location connectionLocation;

    @Before
    public void setUp() {
        this.getValuesFromConfig = new GetValuesFromConfig();
        this.valueProviderServiceMock = (ValueProviderService)Mockito.mock(ValueProviderService.class);
        BaseEventContext eventContextMock = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        this.inputEvent = CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"incomingPayload")).build();
        this.configMock = (Component)Mockito.mock(Component.class);
        DefaultComponentLocation configLocation = new DefaultComponentLocation(Optional.of("config"), Collections.emptyList());
        this.configLocation = Location.builderFromStringRepresentation((String)configLocation.getLocation()).build();
        this.connectionLocation = Location.builderFromStringRepresentation((String)configLocation.getLocation()).addConnectionPart().build();
        Mockito.when((Object)this.configMock.getLocation()).thenReturn((Object)configLocation);
        this.getValuesFromConfig.valueProviderService = this.valueProviderServiceMock;
        this.getValuesFromConfig.setComponent(this.configMock);
        this.getValuesFromConfig.setParameter(A_PARAMETER);
    }

    @Test
    public void failureInConfig() throws Exception {
        ResolvingFailure configResolvingFailure = ToolingTestUtils.newResolvingFailure().build();
        ValueResult configResult = ValueResult.resultFrom((ResolvingFailure)configResolvingFailure);
        ResolvingFailure connectionFailure = ToolingTestUtils.newResolvingFailure().withFailureCode("INVALID_VALUE_RESOLVER_NAME").build();
        ValueResult connectionResult = ValueResult.resultFrom((ResolvingFailure)connectionFailure);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.configLocation, A_PARAMETER)).thenReturn((Object)configResult);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.connectionLocation, A_PARAMETER)).thenReturn((Object)connectionResult);
        try {
            this.getValuesFromConfig.process(this.inputEvent);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (ToolingTestException toolingTestException) {
            MatcherAssert.assertThat((Object)toolingTestException.getFailureMessage(), (Matcher)Matchers.equalTo((Object)configResolvingFailure.getMessage()));
            MatcherAssert.assertThat((Object)toolingTestException.getFailureCode(), (Matcher)Matchers.equalTo((Object)configResolvingFailure.getFailureCode()));
            MatcherAssert.assertThat((Object)toolingTestException.getReason(), (Matcher)Matchers.equalTo((Object)configResolvingFailure.getReason()));
        }
    }

    @Test
    public void failureInConnection() throws Exception {
        ResolvingFailure configResolvingFailure = ToolingTestUtils.newResolvingFailure().withFailureCode("INVALID_VALUE_RESOLVER_NAME").build();
        ValueResult configResult = ValueResult.resultFrom((ResolvingFailure)configResolvingFailure);
        ResolvingFailure connectionFailure = ToolingTestUtils.newResolvingFailure().build();
        ValueResult connectionResult = ValueResult.resultFrom((ResolvingFailure)connectionFailure);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.connectionLocation, A_PARAMETER)).thenReturn((Object)connectionResult);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.configLocation, A_PARAMETER)).thenReturn((Object)configResult);
        try {
            this.getValuesFromConfig.process(this.inputEvent);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (ToolingTestException toolingTestException) {
            MatcherAssert.assertThat((Object)toolingTestException.getFailureMessage(), (Matcher)Matchers.equalTo((Object)connectionFailure.getMessage()));
            MatcherAssert.assertThat((Object)toolingTestException.getFailureCode(), (Matcher)Matchers.equalTo((Object)connectionFailure.getFailureCode()));
            MatcherAssert.assertThat((Object)toolingTestException.getReason(), (Matcher)Matchers.equalTo((Object)connectionFailure.getReason()));
        }
    }

    @Test
    public void valueFromConfigSuccess() throws Exception {
        Value aValue = ValueBuilder.newValue((String)"anId").withDisplayName("aDisplayName").build();
        ValueResult configResult = ValueResult.resultFrom((Set)Sets.newHashSet((Object[])new Value[]{aValue}));
        ResolvingFailure connectionFailure = ToolingTestUtils.newResolvingFailure().withFailureCode("INVALID_VALUE_RESOLVER_NAME").build();
        ValueResult connectionResult = ValueResult.resultFrom((ResolvingFailure)connectionFailure);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.configLocation, A_PARAMETER)).thenReturn((Object)configResult);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.connectionLocation, A_PARAMETER)).thenReturn((Object)connectionResult);
        CoreEvent resultEvent = this.getValuesFromConfig.process(this.inputEvent);
        Map values = (Map)resultEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)values.containsKey(aValue.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat(values.get(aValue.getId()), (Matcher)Matchers.instanceOf(ValuesAdapter.class));
        MatcherAssert.assertThat((Object)((ValuesAdapter)values.get(aValue.getId())).getId(), (Matcher)Matchers.equalTo((Object)aValue.getId()));
        MatcherAssert.assertThat((Object)((ValuesAdapter)values.get(aValue.getId())).getDisplayName(), (Matcher)Matchers.equalTo((Object)aValue.getDisplayName()));
    }

    @Test
    public void valueFromConnectionSuccess() throws Exception {
        Value aValue = ValueBuilder.newValue((String)"anId").withDisplayName("aDisplayName").build();
        ValueResult connectionResult = ValueResult.resultFrom((Set)Sets.newHashSet((Object[])new Value[]{aValue}));
        ResolvingFailure resolvingFailure = ToolingTestUtils.newResolvingFailure().withFailureCode("INVALID_VALUE_RESOLVER_NAME").build();
        ValueResult configResult = ValueResult.resultFrom((ResolvingFailure)resolvingFailure);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.connectionLocation, A_PARAMETER)).thenReturn((Object)connectionResult);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.configLocation, A_PARAMETER)).thenReturn((Object)configResult);
        CoreEvent resultEvent = this.getValuesFromConfig.process(this.inputEvent);
        Map values = (Map)resultEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)values.containsKey(aValue.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat(values.get(aValue.getId()), (Matcher)Matchers.instanceOf(ValuesAdapter.class));
        MatcherAssert.assertThat((Object)((ValuesAdapter)values.get(aValue.getId())).getId(), (Matcher)Matchers.equalTo((Object)aValue.getId()));
        MatcherAssert.assertThat((Object)((ValuesAdapter)values.get(aValue.getId())).getDisplayName(), (Matcher)Matchers.equalTo((Object)aValue.getDisplayName()));
    }

    @Test
    public void initialiseAndDisposedNotPropagatedToComponent() throws Exception {
        Component lifecycleComponentMock = (Component)Mockito.mock(Component.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class}));
        this.getValuesFromConfig.setComponent(lifecycleComponentMock);
        this.getValuesFromConfig.initialise();
        this.getValuesFromConfig.dispose();
        ((Lifecycle)Mockito.verify((Object)((Lifecycle)lifecycleComponentMock), (VerificationMode)Mockito.never())).initialise();
        ((Lifecycle)Mockito.verify((Object)((Lifecycle)lifecycleComponentMock), (VerificationMode)Mockito.never())).dispose();
    }
}

