/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.values;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.values.GetValuesScope;
import org.mule.munit.mtf.tools.internal.tooling.values.model.ValuesAdapter;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.values.ValueBuilder;
import util.ToolingTestUtils;

public class GetValuesScopeTest {
    private static final String A_PARAMETER = "aParam";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private GetValuesScope getValuesScope;
    private ValueProviderService valueProviderServiceMock;
    private CoreEvent inputEvent;
    private Component componentMock;
    private Location location;

    @Before
    public void setUp() {
        this.getValuesScope = new GetValuesScope();
        this.valueProviderServiceMock = (ValueProviderService)Mockito.mock(ValueProviderService.class);
        BaseEventContext eventContextMock = (BaseEventContext)Mockito.mock(BaseEventContext.class);
        this.inputEvent = CoreEvent.builder((EventContext)eventContextMock).message(Message.of((Object)"incomingPayload")).build();
        this.componentMock = (Component)Mockito.mock(Component.class);
        DefaultComponentLocation componentLocation = new DefaultComponentLocation(Optional.of("component"), Collections.emptyList());
        this.location = Location.builderFromStringRepresentation((String)componentLocation.getLocation()).build();
        Mockito.when((Object)this.componentMock.getLocation()).thenReturn((Object)componentLocation);
        this.getValuesScope.valueProviderService = this.valueProviderServiceMock;
        this.getValuesScope.setComponent(this.componentMock);
        this.getValuesScope.setParameter(A_PARAMETER);
    }

    @Test
    public void failureInValues() throws Exception {
        ResolvingFailure resolvingFailure = ToolingTestUtils.newResolvingFailure().build();
        ValueResult failure = ValueResult.resultFrom((ResolvingFailure)resolvingFailure);
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.location, A_PARAMETER)).thenReturn((Object)failure);
        try {
            this.getValuesScope.process(this.inputEvent);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (ToolingTestException toolingTestException) {
            MatcherAssert.assertThat((Object)toolingTestException.getFailureMessage(), (Matcher)Matchers.equalTo((Object)resolvingFailure.getMessage()));
            MatcherAssert.assertThat((Object)toolingTestException.getFailureCode(), (Matcher)Matchers.equalTo((Object)resolvingFailure.getFailureCode()));
            MatcherAssert.assertThat((Object)toolingTestException.getReason(), (Matcher)Matchers.equalTo((Object)resolvingFailure.getReason()));
        }
    }

    @Test
    public void valuesSuccess() throws Exception {
        Value aValue = ValueBuilder.newValue((String)"anId").withDisplayName("aDisplayName").build();
        ValueResult valueResult = ValueResult.resultFrom((Set)Sets.newHashSet((Object[])new Value[]{aValue}));
        Mockito.when((Object)this.valueProviderServiceMock.getValues(this.location, A_PARAMETER)).thenReturn((Object)valueResult);
        CoreEvent resultEvent = this.getValuesScope.process(this.inputEvent);
        Map values = (Map)resultEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)values.containsKey(aValue.getId()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat(values.get(aValue.getId()), (Matcher)Matchers.instanceOf(ValuesAdapter.class));
        MatcherAssert.assertThat((Object)((ValuesAdapter)values.get(aValue.getId())).getId(), (Matcher)Matchers.equalTo((Object)aValue.getId()));
        MatcherAssert.assertThat((Object)((ValuesAdapter)values.get(aValue.getId())).getDisplayName(), (Matcher)Matchers.equalTo((Object)aValue.getDisplayName()));
    }
}

