/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata.model;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataProperty;
import org.mule.runtime.api.util.Preconditions;

public class MetadataKeyAdapter {
    private final MetadataKey metadataKey;

    private MetadataKeyAdapter(MetadataKey metadataKey) {
        Preconditions.checkArgument((metadataKey != null ? 1 : 0) != 0, (String)"Metadata Key cannot be null");
        this.metadataKey = metadataKey;
    }

    public static Map<String, MetadataKeyAdapter> convertToMap(Set<MetadataKey> metadataKeys) {
        return metadataKeys.stream().collect(Collectors.toMap(MetadataKey::getId, MetadataKeyAdapter::new));
    }

    public String getId() {
        return this.metadataKey.getId();
    }

    public String getDisplayName() {
        return this.metadataKey.getDisplayName();
    }

    public String getPartName() {
        return this.metadataKey.getPartName();
    }

    public Set<MetadataProperty> getProperties() {
        return this.metadataKey.getProperties();
    }

    public Map<String, MetadataKeyAdapter> getChilds() {
        return MetadataKeyAdapter.convertToMap(this.metadataKey.getChilds());
    }

    public String toString() {
        return this.metadataKey.toString();
    }
}

