/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.persistence.api.JsonMetadataTypeWriterFactory;
import org.mule.munit.mtf.tools.internal.tooling.AbstractToolingScope;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.metadata.exception.UnexpectedMetadataFailureException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;

public abstract class AbstractMetadataScope
extends AbstractToolingScope {
    @Named(value="_muleNonLazyMetadataService")
    @Inject
    protected MetadataService metadataService;
    protected TypeWriter metadataTypeWriter;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.metadataTypeWriter = JsonMetadataTypeWriterFactory.create();
    }

    protected ToolingTestException toolingTestException(List<MetadataFailure> failures, MetadataComponent expectedComponent) {
        MetadataFailure failure = failures.stream().filter(metadataFailure -> metadataFailure.getFailingComponent().equals((Object)expectedComponent)).findAny().orElseThrow(() -> new UnexpectedMetadataFailureException(expectedComponent, failures));
        return new ToolingTestException(failure.getMessage(), failure.getFailureCode(), failure.getReason());
    }
}

