/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.values;

import javax.inject.Inject;
import javax.inject.Named;
import org.mule.munit.mtf.tools.internal.tooling.AbstractToolingScope;
import org.mule.munit.mtf.tools.internal.tooling.exception.ToolingTestException;
import org.mule.munit.mtf.tools.internal.tooling.values.model.ValuesAdapter;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;

public class GetValuesScope
extends AbstractToolingScope {
    @Named(value="_muleNonLazyValueProviderService")
    @Inject
    protected ValueProviderService valueProviderService;
    protected String parameter;

    @Override
    public Message getMessage() throws ToolingTestException {
        ValueResult valueResult = this.valueProviderService.getValues(this.getComponentLocation(), this.parameter);
        if (valueResult.isSuccess()) {
            return Message.of(ValuesAdapter.convertToMap(valueResult.getValues()));
        }
        ResolvingFailure failure = (ResolvingFailure)valueResult.getFailure().orElseThrow(() -> new IllegalStateException("Getting values was unsuccessful but no failure was provided"));
        throw new ToolingTestException(failure.getMessage(), failure.getFailureCode(), failure.getReason());
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }
}

