/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.connection;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

public class TestConnectivityProcessor
extends SimpleMessageProcessor {
    @Named(value="_muleConnectionManager")
    @Inject
    protected ConnectionManager lazyConnectionManager;
    private ConfigurationProvider config;
    private ErrorType defaultErrorType;

    public void initialise() throws InitialisationException {
        this.defaultErrorType = (ErrorType)this.muleContext.getErrorTypeRepository().getErrorType(Errors.ComponentIdentifiers.Handleable.UNKNOWN).orElseThrow(() -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Unable to find error of type UNKNOWN"), (Initialisable)this));
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        ConnectionValidationResult connectionValidationResult;
        try {
            connectionValidationResult = this.lazyConnectionManager.testConnectivity(this.config.get((Event)event), true);
        }
        catch (NoSuchMethodError e) {
            try {
                connectionValidationResult = ((ConnectionManager)FieldUtils.readField((Object)this.lazyConnectionManager, (String)"delegate", (boolean)true)).testConnectivity(this.config.get((Event)event));
            }
            catch (IllegalAccessException ex) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Unable to get delegate connection manager"), (Throwable)e, (Initialisable)this);
            }
        }
        if (connectionValidationResult.isValid()) {
            return event;
        }
        throw this.buildException(connectionValidationResult);
    }

    public void setConfig(ConfigurationProvider config) {
        this.config = config;
    }

    private MuleRuntimeException buildException(ConnectionValidationResult validationResult) {
        ErrorType errorType = validationResult.getErrorType().orElse(this.defaultErrorType);
        String message = validationResult.getMessage();
        Throwable cause = this.getCause(validationResult);
        return new TypedException(cause, errorType, message);
    }

    private Throwable getCause(ConnectionValidationResult validationResult) {
        Exception exception = validationResult.getException();
        if (exception instanceof ConnectionException && exception.getCause() != null) {
            return exception.getCause();
        }
        return exception;
    }
}

