/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mtf.tools.internal.tooling.metadata.processors;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.persistence.api.JsonMetadataTypeWriterFactory;
import org.mule.metadata.raml.api.JsonRamlTypeLoader;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.metadata.xml.api.schema.SchemaFetcher;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONParser;

public class AssertTypeProcessor
extends SimpleMessageProcessor {
    private static final List<String> EXPECTED_METADATA_TYPE_ATTRIBUTES = Arrays.asList("fromClass", "fromSchema");
    private static final List<String> NON_STRUCTURE_FIELDS = Arrays.asList("annotations", "format");
    @Inject
    protected ExpressionManager expressionManager;
    private TypeWriter jsonMetadataTypeWriter;
    private ClassTypeLoader classTypeLoader;
    private String actual;
    private String fromClass;
    private String fromSchema;

    public CoreEvent process(CoreEvent event) throws MuleException {
        this.assertMetadataTypeJsons(this.evaluateActual(event), this.getExpected());
        return event;
    }

    private String getExpected() {
        if (this.fromClass != null) {
            return this.loadFromClass();
        }
        if (this.fromSchema != null) {
            return this.loadFromSchema();
        }
        throw new IllegalArgumentException("No metadata type to compare was defined. Expected the processor to define one of: " + EXPECTED_METADATA_TYPE_ATTRIBUTES);
    }

    public void initialise() throws InitialisationException {
        this.jsonMetadataTypeWriter = JsonMetadataTypeWriterFactory.create();
        this.classTypeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(this.getClassLoader());
    }

    public void setActual(String actual) {
        this.actual = actual;
    }

    public void setFromClass(String fromClass) {
        this.fromClass = fromClass;
    }

    public void setFromSchema(String fromSchema) {
        this.fromSchema = fromSchema;
    }

    private String evaluateActual(CoreEvent event) {
        TypedValue content = this.actual == null ? event.getMessage().getPayload() : this.expressionManager.evaluate(this.actual, event);
        Object value = content.getValue();
        try {
            Charset encoding = content.getDataType().getMediaType().getCharset().orElse(Charset.defaultCharset());
            if (value instanceof CursorStreamProvider) {
                return IOUtils.toString((InputStream)((InputStream)((CursorStreamProvider)value).openCursor()), (Charset)encoding);
            }
            if (value instanceof InputStream) {
                return IOUtils.toString((InputStream)((InputStream)value), (Charset)encoding);
            }
            if (value instanceof byte[]) {
                return new String((byte[])value, encoding);
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new IllegalArgumentException("Parameter 'actual' can not be coerced to a String, was of type: " + (value == null ? "null" : value.getClass().getCanonicalName()));
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Parameter 'actual' could not be coerced to a String", ioException);
        }
    }

    private void assertMetadataTypeJsons(String actual, String expected) {
        JSONObject expectedObject = this.createJsonObject(expected);
        JSONObject actualObject = this.createJsonObject(actual);
        try {
            JSONAssert.assertEquals((JSONObject)expectedObject, (JSONObject)actualObject, (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)((Throwable)((Object)e)).getMessage());
        }
    }

    private String loadFromClass() {
        try {
            Class<?> clazz = this.getClassLoader().loadClass(this.fromClass);
            MetadataType metadataType = this.classTypeLoader.load(clazz);
            return this.writeMetadataType(metadataType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class " + this.fromClass, e);
        }
    }

    private String writeMetadataType(MetadataType metadataType) {
        return this.jsonMetadataTypeWriter.toString(metadataType);
    }

    private String loadFromSchema() {
        URL schemaUrl = this.getSchemaUrl();
        return this.loadMetadataType(schemaUrl).map(this::writeMetadataType).orElseThrow(() -> new IllegalArgumentException("Unable to obtain a metadata type from file " + this.fromSchema));
    }

    private URL getSchemaUrl() {
        URL schemaResource = this.getClassLoader().getResource(this.fromSchema);
        if (schemaResource == null) {
            throw new IllegalArgumentException("Unable to locate file " + this.fromSchema + " as a resource");
        }
        return schemaResource;
    }

    private Optional<MetadataType> loadMetadataType(URL schemaUrl) {
        try {
            String schemaContent = IOUtils.toString((InputStream)schemaUrl.openStream(), (Charset)Charset.defaultCharset());
            if (this.fromSchema.endsWith(".xsd")) {
                return this.loadXmlSchema(schemaUrl);
            }
            if (this.fromSchema.endsWith(".json")) {
                return this.loadFromJsonSchema(schemaContent);
            }
            if (this.fromSchema.endsWith(".raml")) {
                return this.loadFromRaml(schemaContent);
            }
            throw new IllegalArgumentException("File extension not recognized as a schema file");
        }
        catch (IOException | XmlException e) {
            throw new IllegalArgumentException("Unable to read " + this.fromSchema, e);
        }
    }

    private Optional<MetadataType> loadFromJsonSchema(String schemaContent) {
        return new JsonTypeLoader(schemaContent).load("");
    }

    private Optional<MetadataType> loadXmlSchema(URL schemaUrl) throws XmlException, IOException {
        SchemaCollector schemaCollector = SchemaCollector.getInstance();
        schemaCollector.addSchema(schemaUrl);
        List xsdDependencies = new SchemaFetcher().fetchAll(new URL[]{schemaUrl});
        for (SchemaFetcher.XsdDependency xsdDependency : xsdDependencies) {
            schemaCollector.addSchema(xsdDependency.getDependency());
        }
        return new XmlTypeLoader(schemaCollector).load(this.getRootElementName(), null);
    }

    private Optional<MetadataType> loadFromRaml(String schemaContent) {
        return new JsonRamlTypeLoader(schemaContent, this.fromSchema).load("");
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private JSONObject createJsonObject(String jsonString) {
        Object json = JSONParser.parseJSON((String)jsonString);
        if (json instanceof JSONObject) {
            return this.actionOverObject((JSONObject)json, this.removeNonComparableFields());
        }
        throw new IllegalArgumentException("Assert type can only compare against a Json Object");
    }

    private Consumer<JSONObject> removeNonComparableFields() {
        return jsonObject -> NON_STRUCTURE_FIELDS.forEach(arg_0 -> ((JSONObject)jsonObject).remove(arg_0));
    }

    private JSONObject actionOverObject(JSONObject jsonObject, Consumer<JSONObject> action) {
        action.accept(jsonObject);
        jsonObject.keys().forEachRemaining(key -> {
            Object field = jsonObject.get(key);
            if (field instanceof JSONObject) {
                this.actionOverObject((JSONObject)field, action);
            } else if (field instanceof JSONArray) {
                for (Object item : (JSONArray)field) {
                    if (!(item instanceof JSONObject)) continue;
                    this.actionOverObject((JSONObject)item, action);
                }
            }
        });
        return jsonObject;
    }

    private QName getRootElementName() throws XmlException, IOException {
        SchemaGlobalElement[] schemaGlobalElements = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{SchemaDocument.Factory.parse((URL)this.getSchemaUrl())}, (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), null).globalElements();
        Preconditions.checkArgument((schemaGlobalElements.length > 0 ? 1 : 0) != 0, (Object)("Provided schema " + this.fromSchema + " does not have a root element"));
        return schemaGlobalElements[0].getName();
    }
}

