/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.log;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.mule.munit.common.log.FileUtils;

public class TestsLogConfigurationHelper {
    public static final String LOG4J_CONFIGURATION_FILE = "log4j.configurationFile";
    public static final String CONFIG_DEFAULT_FILE_NAME = "log4j2.xml";
    public static final String CONFIG_TEST_FILE_NAME = "log4j2-test.xml";
    private static final String NULL_CONFIG_FILE = "NULL_CONFIG_FILE";
    private static final ThreadLocal<String> LOGGING_CONFIG_CACHE = new ThreadLocal();

    public static void configureLoggingForTest(Class<?> testClass) {
        String logConfigPath = LOGGING_CONFIG_CACHE.get();
        if (logConfigPath == null) {
            logConfigPath = TestsLogConfigurationHelper.findLogConfigurationPath(testClass);
        }
        TestsLogConfigurationHelper.forceConfigFile(logConfigPath);
    }

    public static void clearLoggingConfig() {
        LOGGING_CONFIG_CACHE.remove();
        System.clearProperty(LOG4J_CONFIGURATION_FILE);
    }

    private static String findLogConfigurationPath(Class<?> testClass) {
        File logConfigFile;
        String folderPath;
        String encodedFolder = testClass.getClassLoader().getResource("").getPath().toString();
        try {
            folderPath = URLDecoder.decode(encodedFolder, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return NULL_CONFIG_FILE;
        }
        File folder = new File(folderPath);
        if (folder != null && "target".equals(folder.getParentFile().getName())) {
            folder = folder.getParentFile();
        }
        if ((logConfigFile = FileUtils.findFileByName(folder, CONFIG_TEST_FILE_NAME, true)) == null) {
            logConfigFile = FileUtils.findFileByName(folder, CONFIG_DEFAULT_FILE_NAME, true);
        }
        String logConfigPath = logConfigFile != null && logConfigFile.isFile() ? logConfigFile.getAbsolutePath() : NULL_CONFIG_FILE;
        LOGGING_CONFIG_CACHE.set(logConfigPath);
        return logConfigPath;
    }

    private static void forceConfigFile(String logConfigFile) {
        if (!NULL_CONFIG_FILE.equals(logConfigFile)) {
            System.setProperty(LOG4J_CONFIGURATION_FILE, logConfigFile);
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        ctx.reconfigure();
    }
}

