/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.utils;

import org.mule.api.MuleContext;
import org.mule.module.scripting.component.Scriptable;

import javax.script.Bindings;
import javax.script.ScriptException;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static org.apache.commons.lang.StringUtils.isNotBlank;

public class ScriptableRunner {

    public Object run(String scriptName, MuleContext muleContext) {

        checkArgument(isNotBlank(scriptName), "The scriptName should not be null nor empty");
        checkNotNull(muleContext, "The muleContext must not be null");

        Object registeredScript = muleContext.getRegistry().lookupObject(scriptName);
        checkNotNull(registeredScript, "The script called " + scriptName + " could not be found");

        if (registeredScript instanceof Scriptable) {
            Scriptable script = (Scriptable) registeredScript;
            Bindings bindings = script.getScriptEngine().createBindings();
            script.populateDefaultBindings(bindings);

            try {
                return script.runScript(bindings);
            } catch (ScriptException e) {
                throw new RuntimeException("Your script has an execution error ", e);
            }
        }

        throw new IllegalArgumentException("The scriptName provided does not belong to a Mule Script");
    }
}
