/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.spring.config;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.parsers.DOMParser;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.config.ConfigResource;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.module.xml.transformer.DomDocumentToXml;
import org.mule.module.xml.transformer.ObjectToXml;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.mule.module.xml.transformer.XmlToObject;
import org.mule.module.xml.transformer.jaxb.JAXBMarshallerTransformer;
import org.mule.module.xml.transformer.jaxb.JAXBUnmarshallerTransformer;
import org.mule.munit.runner.spring.config.MunitApplicationContext;
import org.mule.munit.runner.spring.config.model.BeanDefinitionGenericBuilder;
import org.mule.munit.runner.spring.config.reader.MunitBeanDefinitionScopper;
import org.mule.transformer.simple.ByteArrayToObject;
import org.mule.transformer.simple.ByteArrayToSerializable;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.simple.ObjectToString;
import org.mule.transformer.simple.SerializableToByteArray;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;

public class MunitSpringXmlConfigurationBuilder
extends SpringXmlConfigurationBuilder {
    private BeanDefinitionGenericBuilder mockingConfiguration;
    private DOMParser munitDomParser;
    private Class endpointFactoryClass;
    private Map<String, Class> beansToRegister;
    private Class munitFactoryPostProcessorClass;
    private String munitFactoryPostProcessorBeanId;

    private MunitSpringXmlConfigurationBuilder(String configResources, BeanDefinitionGenericBuilder configuration) throws ConfigurationException {
        super(configResources);
        this.mockingConfiguration = configuration;
        this.beansToRegister = new HashMap<String, Class>();
        this.addDefaultBeansToScoppeOut();
    }

    public void addBeanClassToScopeOut(String beanClassCanonicalName) {
        Class<?> beanClass = null;
        try {
            beanClass = Class.forName(beanClassCanonicalName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Fail to register class [" + beanClassCanonicalName + "] to scope out." + e.getMessage());
        }
        this.addBeanClassToScopeOut(beanClass);
    }

    public void addBeanClassToScopeOut(Class beanClass) {
        MunitBeanDefinitionScopper.addBeanClass(beanClass);
    }

    public void clearBeanClassList() {
        MunitBeanDefinitionScopper.clearBeanClassList();
    }

    protected void addDefaultBeansToScoppeOut() {
        this.clearBeanClassList();
        this.addBeanClassToScopeOut(AbstractXmlTransformer.class);
        this.addBeanClassToScopeOut(ObjectToString.class);
        this.addBeanClassToScopeOut(ByteArrayToObject.class);
        this.addBeanClassToScopeOut(ByteArrayToSerializable.class);
        this.addBeanClassToScopeOut(ObjectToString.class);
        this.addBeanClassToScopeOut(SerializableToByteArray.class);
        this.addBeanClassToScopeOut(ObjectToByteArray.class);
        this.addBeanClassToScopeOut(DomDocumentToXml.class);
        this.addBeanClassToScopeOut(JAXBMarshallerTransformer.class);
        this.addBeanClassToScopeOut(ObjectToXml.class);
        this.addBeanClassToScopeOut(XmlToDomDocument.class);
        this.addBeanClassToScopeOut(JAXBUnmarshallerTransformer.class);
        this.addBeanClassToScopeOut(XmlToObject.class);
    }

    protected ApplicationContext createApplicationContext(MuleContext muleContext, ConfigResource[] configResources) throws Exception {
        return this.doCreateApplicationContext(muleContext, configResources);
    }

    protected ApplicationContext doCreateApplicationContext(MuleContext muleContext, ConfigResource[] configResources) {
        MunitApplicationContext munitApplicationContext = new MunitApplicationContext(muleContext, configResources, this.endpointFactoryClass, this.munitDomParser, this.munitFactoryPostProcessorBeanId);
        for (String beanId : this.beansToRegister.keySet()) {
            Class beanClass = this.beansToRegister.get(beanId);
            munitApplicationContext.putBeanDefinitionToRegister(beanId, (BeanDefinition)new RootBeanDefinition(beanClass));
        }
        if (this.mockingConfiguration != null) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition();
            beanDefinition.setBeanClass(this.munitFactoryPostProcessorClass);
            MutablePropertyValues propertyValues = new MutablePropertyValues();
            for (String attributeName : this.mockingConfiguration.buildAttributeMap().keySet()) {
                Object attributeValue = this.mockingConfiguration.buildAttributeMap().get(attributeName);
                propertyValues.add(attributeName, attributeValue);
            }
            beanDefinition.setPropertyValues(propertyValues);
            munitApplicationContext.putBeanDefinitionToRegister(this.munitFactoryPostProcessorBeanId, (BeanDefinition)beanDefinition);
        }
        return munitApplicationContext;
    }

    public BeanDefinitionGenericBuilder getMockingConfiguration() {
        return this.mockingConfiguration;
    }

    public DOMParser getMunitDomParser() {
        return this.munitDomParser;
    }

    public Class getEndpointFactoryClass() {
        return this.endpointFactoryClass;
    }

    public Map<String, Class> getBeansToRegister() {
        return this.beansToRegister;
    }

    public Class getMunitFactoryPostProcessorClass() {
        return this.munitFactoryPostProcessorClass;
    }

    public String getMunitFactoryPostProcessorBeanId() {
        return this.munitFactoryPostProcessorBeanId;
    }

    public static class ConfigurationBuilderBuilder {
        private String configResources;
        private BeanDefinitionGenericBuilder mockingConfiguration;
        private DOMParser munitDomParser;
        private Class endpointFactoryClass;
        private Map<String, Class> beansToRegister;
        private Class munitFactoryPostProcessorClass;
        private String munitFactoryPostProcessorBeanId;

        public ConfigurationBuilderBuilder(String configResources) {
            this.configResources = configResources;
            this.beansToRegister = new HashMap<String, Class>();
        }

        public ConfigurationBuilderBuilder withMockingConfiguration(BeanDefinitionGenericBuilder mockingConfiguration) {
            this.mockingConfiguration = mockingConfiguration;
            return this;
        }

        public ConfigurationBuilderBuilder withEndpointFactoryClass(Class endpointFactoryClass) {
            Preconditions.checkNotNull((Object)endpointFactoryClass, (Object)"The class must not be null.");
            this.endpointFactoryClass = endpointFactoryClass;
            return this;
        }

        public ConfigurationBuilderBuilder withMunitFactoryPostProcessor(String beanId, Class postProcessorClass) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)beanId), (Object)"The bean ID must not be null nor empty.");
            Preconditions.checkNotNull((Object)postProcessorClass, (Object)"The class must not be null.");
            this.munitFactoryPostProcessorBeanId = beanId;
            this.munitFactoryPostProcessorClass = postProcessorClass;
            return this;
        }

        public ConfigurationBuilderBuilder withBeanToRegister(String beanId, Class beanClass) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)beanId), (Object)"The bean ID must not be null nor empty.");
            Preconditions.checkNotNull((Object)beanClass, (Object)"The bean class not be null.");
            this.beansToRegister.put(beanId, beanClass);
            return this;
        }

        public ConfigurationBuilderBuilder withMunitDomParser(DOMParser munitDomParser) {
            Preconditions.checkNotNull((Object)munitDomParser, (Object)"The dom parsers must not be null.");
            this.munitDomParser = munitDomParser;
            return this;
        }

        public MunitSpringXmlConfigurationBuilder build() throws ConfigurationException {
            Preconditions.checkNotNull((Object)this.endpointFactoryClass, (Object)"MunitSpringXmlConfigurationBuilder build fail. The class must not be null.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.munitFactoryPostProcessorBeanId), (Object)"MunitSpringXmlConfigurationBuilder build fail. The bean ID must not be null nor empty.");
            Preconditions.checkNotNull((Object)this.munitFactoryPostProcessorClass, (Object)"MunitSpringXmlConfigurationBuilder build fail. The munit factory post processor class must not be null.");
            Preconditions.checkNotNull((Object)this.munitDomParser, (Object)"MunitSpringXmlConfigurationBuilder build fail. The munit dom parsers must not be null");
            MunitSpringXmlConfigurationBuilder builder = new MunitSpringXmlConfigurationBuilder(this.configResources, this.mockingConfiguration);
            builder.endpointFactoryClass = this.endpointFactoryClass;
            builder.munitFactoryPostProcessorBeanId = this.munitFactoryPostProcessorBeanId;
            builder.munitFactoryPostProcessorClass = this.munitFactoryPostProcessorClass;
            builder.beansToRegister.putAll(this.beansToRegister);
            builder.munitDomParser = this.munitDomParser;
            return builder;
        }
    }
}

