/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.spring.config.reader;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.processor.MessageProcessor;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.modules.interceptor.spring.BeanFactoryMethodBuilder;
import org.mule.munit.runner.interceptor.AbstractMessageProcessorInterceptorFactory;
import org.mule.munit.runner.spring.config.reader.MunitBeanDefinitionScopper;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MunitHandlerWrapper
implements NamespaceHandler {
    public static Integer CONSTRUCTOR_ARG_LIMIT = -1;
    private static final Integer DEFAULT_CONSTRUCTOR_ARGS_LIMIT = 5;
    private NamespaceHandler realHandler;
    private transient Log logger = LogFactory.getLog(this.getClass());

    public MunitHandlerWrapper(NamespaceHandler realHandler) {
        this.realHandler = realHandler;
    }

    public static void setConstructorArgLimit(Integer limit) {
        CONSTRUCTOR_ARG_LIMIT = limit;
    }

    public void init() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinition beanDefinition = this.realHandler.parse(element, parserContext);
        if (beanDefinition == null || element == null) {
            return beanDefinition;
        }
        try {
            Class<?> beanType = Class.forName(beanDefinition.getBeanClassName());
            if (this.byPassDueToException(beanType)) {
                return beanDefinition;
            }
            if (this.shouldEnhanceBeanDefinitionWithMunit(beanDefinition)) {
                String tagName = element.getTagName();
                if (this.isBeanDefinitionEnhanceableByMunit(beanDefinition, tagName)) {
                    String filename = parserContext.getReaderContext().getResource().getFilename();
                    BeanFactoryMethodBuilder methodBuilder = AbstractMessageProcessorInterceptorFactory.addFactoryDefinitionTo((AbstractBeanDefinition)beanDefinition);
                    MessageProcessorId mpId = new MessageProcessorId(this.getNameFrom(tagName), this.getNamespaceFrom(tagName));
                    methodBuilder.withConstructorArguments(new Object[]{beanType, mpId, this.getAttributes(element), filename, element.getAttribute("__MUNIT_LINE_NUMBER")});
                    MunitBeanDefinitionScopper.makeBeanDefinitionSingletonIfApplicable(beanDefinition);
                    return beanDefinition;
                }
                this.logger.warn((Object)("Bean Definition for " + tagName + " is not enhanceable by MUnit."));
            }
        }
        catch (ClassNotFoundException e) {
            return beanDefinition;
        }
        return beanDefinition;
    }

    protected boolean shouldEnhanceBeanDefinitionWithMunit(BeanDefinition beanDefinition) throws ClassNotFoundException {
        Class<?> beanType = Class.forName(beanDefinition.getBeanClassName());
        return this.isMessageProcessor(beanType) && AbstractBeanDefinition.class.isAssignableFrom(beanDefinition.getClass()) && StringUtils.isEmpty((String)beanDefinition.getFactoryMethodName());
    }

    protected boolean isBeanDefinitionEnhanceableByMunit(BeanDefinition beanDefinition, String tagName) {
        int constructorArgLimit = CONSTRUCTOR_ARG_LIMIT != -1 ? CONSTRUCTOR_ARG_LIMIT : DEFAULT_CONSTRUCTOR_ARGS_LIMIT;
        return !StringUtils.isEmpty((String)tagName) && beanDefinition.getConstructorArgumentValues().getArgumentCount() <= constructorArgLimit;
    }

    private boolean byPassDueToException(Class<?> beanType) {
        return "org.mule.module.extension.internal.config.ConfigurationInstanceProviderFactoryBean".equals(beanType.getCanonicalName());
    }

    private Map<String, String> getAttributes(Element element) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            if ("__MUNIT_LINE_NUMBER".equals(attr.getNodeName())) continue;
            attrs.put(attr.getNodeName(), attr.getNodeValue());
        }
        return attrs;
    }

    private String getNameFrom(String tagName) {
        String[] splitedName = tagName.split(":");
        if (splitedName.length == 1) {
            return splitedName[0];
        }
        if (splitedName.length > 1) {
            return splitedName[1];
        }
        return "";
    }

    private String getNamespaceFrom(String tagName) {
        String[] splitedName = tagName.split(":");
        if (splitedName.length > 1) {
            return splitedName[0];
        }
        return "mule";
    }

    private boolean isMessageProcessor(Class<?> beanType) {
        return MessageProcessor.class.isAssignableFrom(beanType) || FactoryBean.class.isAssignableFrom(beanType);
    }

    public BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder definition, ParserContext parserContext) {
        return definition;
    }
}

