/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner;

import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.mule.munit.common.util.MunitMuleTestUtils;

import static com.google.common.base.Preconditions.checkArgument;
import static org.apache.commons.lang.StringUtils.isNotBlank;

/**
 * The purpose of this class is to generate a simple MuleEvent based on a dummy flow construct
 */
public class MunitMuleEventBuilder {
    //    public static final String MUNIT_TEST_FLOW_CONSTRUCT_NAME = MuleTestUtils.APPLE_FLOW;
    public static final String MUNIT_TEST_FLOW_CONSTRUCT_NAME = MunitMuleTestUtils.APPLE_FLOW;

    public static final String ONE_WAY = "ONE_WAY";
    public static final String REQUEST_RESPONSE = "REQUEST_RESPONSE";

    public static MuleEvent buildGenericMuleEvent(MuleContext muleContext) {
        return buildGenericMuleEvent(muleContext, REQUEST_RESPONSE);
    }

    public static MuleEvent buildGenericMuleEvent(MuleContext muleContext, String exchangePattern) {
        MessageExchangePattern messageExchangePattern = getMessageExchangePattern(exchangePattern);
        try {
            Flow testFlow = (Flow) muleContext.getRegistry().lookupFlowConstruct(MUNIT_TEST_FLOW_CONSTRUCT_NAME);
            if (null == testFlow) {
                testFlow = MunitMuleTestUtils.getTestFlow(muleContext);
            }

            return new DefaultMuleEvent(new DefaultMuleMessage("", muleContext), messageExchangePattern, testFlow);
        } catch (Exception e) {
            return null;
        }
    }

    public static MuleEvent buildMuleEvent(MuleContext muleContext, FlowConstruct flowConstruct) {
        return buildMuleEvent(muleContext, REQUEST_RESPONSE, flowConstruct);
    }

    public static MuleEvent buildMuleEvent(MuleContext muleContext, String exchangePattern, FlowConstruct flowConstruct) {
        MessageExchangePattern messageExchangePattern = getMessageExchangePattern(exchangePattern);
        try {
            return new DefaultMuleEvent(new DefaultMuleMessage("", muleContext), messageExchangePattern, flowConstruct);
        } catch (Exception e) {
            return null;
        }
    }

    private static MessageExchangePattern getMessageExchangePattern(String exchangePattern) {
        MessageExchangePattern messageExchangePattern = findMessageExchangePattern(exchangePattern);
        if (null == messageExchangePattern) {
            throw new IllegalArgumentException("The exchange pattern should be one of: " + ONE_WAY + ", " + REQUEST_RESPONSE);
        }
        return messageExchangePattern;
    }

    private static MessageExchangePattern findMessageExchangePattern(String exchangePattern) {
        checkArgument(isNotBlank(exchangePattern), "The exchange pattern must not be null nor empty.");

        if (ONE_WAY.equals(exchangePattern)) {
            return MessageExchangePattern.ONE_WAY;
        }
        if (REQUEST_RESPONSE.equals(exchangePattern)) {
            return MessageExchangePattern.REQUEST_RESPONSE;
        }

        return null;
    }


}
