/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.api.spring.config.parsers;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.munit.api.spring.config.parsers.AbstractDefinitionParser;
import org.mule.munit.api.spring.config.parsers.model.ParseableElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class MunitGenericDefinitionParser
extends AbstractDefinitionParser {
    private Class messageProcessorClass;
    private String scope;
    private Map<String, String> attributePropertyMap;
    private Map<String, ParseableElement> childElementMap;
    private Boolean withAttachProcessorDefinition = true;
    private Map<String, String> elementAttributes;

    private MunitGenericDefinitionParser(Class messageProcessorClass) {
        this.messageProcessorClass = messageProcessorClass;
        this.attributePropertyMap = new HashMap<String, String>();
        this.childElementMap = new HashMap<String, ParseableElement>();
        this.elementAttributes = new HashMap<String, String>();
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.addAttributesToElement(element);
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.setScope(this.scope);
        this.defineLifeCyleMethodMapping(builder);
        this.parseMessageProcessorAttributes(element, builder);
        this.parseChildElements(element, builder, parserContext);
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        if (this.withAttachProcessorDefinition.booleanValue()) {
            this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        }
        return definition;
    }

    protected void addAttributesToElement(Element element) {
        for (String name : this.elementAttributes.keySet()) {
            String value = this.elementAttributes.get(name);
            element.setAttribute(name, value);
        }
    }

    protected BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)this.messageProcessorClass.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the message processor class " + this.messageProcessorClass.getName() + " was not found in the classpath.", new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    protected void defineLifeCyleMethodMapping(BeanDefinitionBuilder builder) {
        if (Initialisable.class.isAssignableFrom(this.messageProcessorClass)) {
            builder.setInitMethodName("initialise");
        }
        if (Disposable.class.isAssignableFrom(this.messageProcessorClass)) {
            builder.setDestroyMethodName("dispose");
        }
    }

    protected void parseMessageProcessorAttributes(Element element, BeanDefinitionBuilder builder) {
        this.parseElementAttributes(this.attributePropertyMap, element, builder);
    }

    protected void parseChildElements(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        for (String elementName : this.childElementMap.keySet()) {
            ParseableElement parseableElement = this.childElementMap.get(elementName);
            this.parseChildElementByType(parseableElement, element, builder, parserContext);
        }
    }

    public Class getMessageProcessorClass() {
        return this.messageProcessorClass;
    }

    public Map<String, String> getAttributePropertyMap() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.putAll(this.attributePropertyMap);
        return toReturn;
    }

    public Map<String, ParseableElement> getChildElementMap() {
        HashMap<String, ParseableElement> toReturn = new HashMap<String, ParseableElement>();
        toReturn.putAll(this.childElementMap);
        return toReturn;
    }

    public Boolean getWithAttachProcessorDefinition() {
        return this.withAttachProcessorDefinition;
    }

    public Map<String, String> getElementAttributes() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.putAll(this.elementAttributes);
        return toReturn;
    }

    public String getScope() {
        return this.scope;
    }

    public static class MunitGenericDefinitionParserBuilder {
        protected Class messageProcessorClass;
        protected String scope;
        protected Map<String, String> attributePropertyMap;
        protected Map<String, ParseableElement> childElementMap;
        protected Boolean withAttachProcessorDefinition = true;
        protected Map<String, String> elementAttributes;

        public MunitGenericDefinitionParserBuilder(Class messageProcessorClass) {
            Preconditions.checkNotNull((Object)messageProcessorClass, (Object)"The message processor class must not be null.");
            this.messageProcessorClass = messageProcessorClass;
            this.attributePropertyMap = new HashMap<String, String>();
            this.childElementMap = new HashMap<String, ParseableElement>();
            this.elementAttributes = new HashMap<String, String>();
        }

        public MunitGenericDefinitionParserBuilder withScope(String scope) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)scope), (Object)"The scope must not be null nor empty.");
            if (!scope.equals("prototype") && !scope.equals("singleton")) {
                throw new IllegalArgumentException("The provided scope is not valid.");
            }
            this.scope = scope;
            return this;
        }

        public MunitGenericDefinitionParserBuilder withAttribute(String attributeName, String propertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)attributeName), (Object)"The attribute name must not be null nor empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)propertyName), (Object)"The property name must not be null nor empty.");
            this.attributePropertyMap.put(attributeName, propertyName);
            return this;
        }

        public MunitGenericDefinitionParserBuilder withChildElement(String childElementName, ParseableElement childElement) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)childElementName), (Object)"The child element name must not be null nor empty.");
            Preconditions.checkNotNull((Object)childElement, (Object)"The child Element must not be null.");
            this.childElementMap.put(childElementName, childElement);
            return this;
        }

        public MunitGenericDefinitionParserBuilder withNoAttachProcessorDefinition() {
            this.withAttachProcessorDefinition = false;
            return this;
        }

        public MunitGenericDefinitionParserBuilder withElementAttribute(String name, String value) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"The name must not be null nor empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)value), (Object)"The value must not be null nor empty.");
            this.elementAttributes.put(name, value);
            return this;
        }

        public MunitGenericDefinitionParser build() {
            Preconditions.checkNotNull((Object)this.messageProcessorClass, (Object)"Build Fail. The message processor class can not be null.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.scope), (Object)"Build Fail.The scope can not be null nor empty.");
            MunitGenericDefinitionParser parser = new MunitGenericDefinitionParser(this.messageProcessorClass);
            parser.scope = this.scope;
            parser.attributePropertyMap.putAll(this.attributePropertyMap);
            parser.withAttachProcessorDefinition = this.withAttachProcessorDefinition;
            parser.childElementMap.putAll(this.childElementMap);
            parser.elementAttributes.putAll(this.elementAttributes);
            return parser;
        }
    }
}

