/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.processors;

import java.lang.reflect.Method;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodProxy;
import org.mule.api.MuleEvent;
import org.mule.processor.AbstractInterceptingMessageProcessorBase;

public class InterceptingMessageProcessorHandler {
    private static final String PROCESS_NEXT_METHOD_NAME = "processNext";
    private static final Class PROCESS_NEXT_RETURN_TYPE = MuleEvent.class;
    private static final Class PROCESS_NEXT_ARGUMENT_TYPE = MuleEvent.class;
    private Object messageProcessor;

    public InterceptingMessageProcessorHandler(Object messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public boolean shouldHandle() {
        return AbstractInterceptingMessageProcessorBase.class.isAssignableFrom(this.messageProcessor.getClass());
    }

    public Object invokeProcessNext(MuleEvent event) throws Throwable {
        if (!this.shouldHandle()) {
            return event;
        }
        MethodProxy methodProxy = this.buildMethodProxy();
        if (methodProxy != null) {
            Object[] args = new Object[]{event};
            return methodProxy.invoke(this.messageProcessor, args);
        }
        Method method = AbstractInterceptingMessageProcessorBase.class.getDeclaredMethod(PROCESS_NEXT_METHOD_NAME, PROCESS_NEXT_ARGUMENT_TYPE);
        method.setAccessible(true);
        return method.invoke(this.messageProcessor, event);
    }

    protected MethodProxy buildMethodProxy() {
        Type[] argumentTypes = new Type[]{Type.getType((Class)PROCESS_NEXT_ARGUMENT_TYPE)};
        Signature signature = new Signature(PROCESS_NEXT_METHOD_NAME, Type.getType((Class)PROCESS_NEXT_RETURN_TYPE), argumentTypes);
        try {
            return MethodProxy.find(this.messageProcessor.getClass(), (Signature)signature);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

