/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.work.WorkListener;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.config.AnnotationsConfigurationBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.ExtensionsManagerConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.munit.common.log.TestsLogConfigurationHelper;
import org.mule.munit.common.util.TestingWorkListener;
import org.mule.munit.runner.actions.ConfigureLoggingForTestAction;
import org.mule.munit.runner.actions.MuleContextFactoryAction;
import org.mule.util.ClassUtils;

public class MunitMuleContextFactory {
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = AnnotationsConfigurationBuilder.class.getCanonicalName();
    protected Properties startUpProperties;
    protected List<ConfigurationBuilder> builders;
    protected List<MuleContextFactoryAction> beforeCreationActions;
    protected List<MuleContextFactoryAction> afterCreationActions;

    public static void clearLoggingConfiguration() {
        TestsLogConfigurationHelper.clearLoggingConfig();
    }

    public MunitMuleContextFactory(Properties startUpProperties, List<ConfigurationBuilder> builders) {
        Preconditions.checkNotNull(builders, (Object)"The builder list must not be null.");
        Preconditions.checkNotNull((Object)startUpProperties, (Object)"The start up properties must not be null.");
        this.builders = builders;
        this.startUpProperties = startUpProperties;
        this.beforeCreationActions = new ArrayList<MuleContextFactoryAction>();
        this.afterCreationActions = new ArrayList<MuleContextFactoryAction>();
        this.registerDefaultActions();
    }

    public void registerBeforeCreationAction(MuleContextFactoryAction action) {
        Preconditions.checkNotNull((Object)action, (Object)"The action must not be null.");
        this.beforeCreationActions.add(action);
    }

    public void registerAfterCreationAction(MuleContextFactoryAction action) {
        Preconditions.checkNotNull((Object)action, (Object)"The action must not be null.");
        this.afterCreationActions.add(action);
    }

    public MuleContext createMuleContext() throws Exception {
        this.performActionsBeforeCreation();
        List<ConfigurationBuilder> builders = this.getConfigurationBuilderList();
        DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
        this.configureMuleContextBuilder((MuleContextBuilder)contextBuilder);
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        MuleContext context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
        ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
        context.getNotificationManager().setNotificationDynamic(true);
        context.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        this.performActionsAfterCreation(context);
        return context;
    }

    protected void performActionsBeforeCreation() {
        for (MuleContextFactoryAction action : this.beforeCreationActions) {
            action.perform(null);
        }
    }

    protected void performActionsAfterCreation(MuleContext context) {
        for (MuleContextFactoryAction action : this.afterCreationActions) {
            action.perform(context);
        }
    }

    protected List<ConfigurationBuilder> getConfigurationBuilderList() throws Exception {
        ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
        builders.add((ConfigurationBuilder)new SimpleConfigurationBuilder((Map)this.startUpProperties));
        builders.add((ConfigurationBuilder)new ExtensionsManagerConfigurationBuilder());
        this.addBuilderIfPresent(builders, CLASSNAME_ANNOTATIONS_CONFIG_BUILDER);
        builders.addAll(this.builders);
        return builders;
    }

    protected void configureMuleContextBuilder(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }

    protected void addBuilderIfPresent(List<ConfigurationBuilder> builders, String builderClassName) throws Exception {
        if (ClassUtils.isClassOnPath((String)builderClassName, this.getClass())) {
            builders.add((ConfigurationBuilder)ClassUtils.instanciateClass((String)builderClassName, (Object[])ClassUtils.NO_ARGS, this.getClass()));
        }
    }

    protected void registerDefaultActions() {
        this.registerBeforeCreationAction(new ConfigureLoggingForTestAction());
    }
}

