/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.api.spring.config.parsers;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.munit.api.spring.config.parsers.MunitDefinitionParser;
import org.mule.munit.api.spring.config.parsers.model.ChildElement;
import org.mule.munit.api.spring.config.parsers.model.ListChildElement;
import org.mule.munit.api.spring.config.parsers.model.MapChildElement;
import org.mule.munit.api.spring.config.parsers.model.NestedChildElement;
import org.mule.munit.api.spring.config.parsers.model.ParseableElement;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractDefinitionParser
implements BeanDefinitionParser,
MunitDefinitionParser {
    private TemplateParser.PatternInfo patternInfo = TemplateParser.createMuleStyleParser().getStyle();

    protected boolean hasAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        return value != null && !StringUtils.isBlank((String)value);
    }

    protected void setRef(BeanDefinitionBuilder builder, String propertyName, String ref) {
        if (!this.isMuleExpression(ref)) {
            builder.addPropertyValue(propertyName, (Object)new RuntimeBeanReference(ref));
        } else {
            builder.addPropertyValue(propertyName, (Object)ref);
        }
    }

    protected boolean isMuleExpression(String value) {
        return value.startsWith(this.patternInfo.getPrefix()) || value.endsWith(this.patternInfo.getSuffix());
    }

    protected ManagedList parseList(Element element, String childElementName, ParseDelegate parserDelegate) {
        ManagedList managedList = new ManagedList();
        List childDomElements = DomUtils.getChildElementsByTagName((Element)element, (String)childElementName);
        for (Element childDomElement : childDomElements) {
            if (this.hasAttribute(childDomElement, "value-ref")) {
                if (!this.isMuleExpression(childDomElement.getAttribute("value-ref"))) {
                    managedList.add((Object)new RuntimeBeanReference(childDomElement.getAttribute("value-ref")));
                    continue;
                }
                managedList.add((Object)childDomElement.getAttribute("value-ref"));
                continue;
            }
            managedList.add(parserDelegate.parse(childDomElement));
        }
        return managedList;
    }

    protected void parseListAndSetProperty(Element element, BeanDefinitionBuilder builder, String fieldName, String parentElementName, String childElementName, ParseDelegate parserDelegate) {
        Element domElement = DomUtils.getChildElementByTagName((Element)element, (String)parentElementName);
        if (domElement != null) {
            if (this.hasAttribute(domElement, "ref")) {
                this.setRef(builder, fieldName, domElement.getAttribute("ref"));
            } else {
                ManagedList managedList = this.parseList(domElement, childElementName, parserDelegate);
                builder.addPropertyValue(fieldName, (Object)managedList);
            }
        }
    }

    protected ManagedMap parseMap(Element element, String childElementName, ParseDelegate parserDelegate) {
        ManagedMap managedMap = new ManagedMap();
        List childDomElements = DomUtils.getChildElementsByTagName((Element)element, (String)childElementName);
        if (childDomElements.size() == 0) {
            childDomElements = DomUtils.getChildElements((Element)element);
        }
        for (Element childDomElement : childDomElements) {
            Object key = null;
            key = this.hasAttribute(childDomElement, "key-ref") ? new RuntimeBeanReference(childDomElement.getAttribute("key-ref")) : (this.hasAttribute(childDomElement, "key") ? childDomElement.getAttribute("key") : childDomElement.getTagName());
            if (this.hasAttribute(childDomElement, "value-ref")) {
                if (!this.isMuleExpression(childDomElement.getAttribute("value-ref"))) {
                    managedMap.put(key, (Object)new RuntimeBeanReference(childDomElement.getAttribute("value-ref")));
                } else {
                    managedMap.put(key, (Object)childDomElement.getAttribute("value-ref"));
                }
            }
            if (this.hasAttribute(childDomElement, "value")) {
                managedMap.put(key, (Object)childDomElement.getAttribute("value"));
                continue;
            }
            managedMap.put(key, parserDelegate.parse(childDomElement));
        }
        return managedMap;
    }

    protected void parseMapAndSetProperty(Element element, BeanDefinitionBuilder builder, String fieldName, String parentElementName, String childElementName, ParseDelegate parserDelegate) {
        Element domElement = DomUtils.getChildElementByTagName((Element)element, (String)parentElementName);
        if (domElement != null) {
            if (this.hasAttribute(domElement, "ref")) {
                this.setRef(builder, fieldName, domElement.getAttribute("ref"));
            } else {
                ManagedMap managedMap = this.parseMap(domElement, childElementName, parserDelegate);
                builder.addPropertyValue(fieldName, (Object)managedMap);
            }
        }
    }

    protected void attachProcessorDefinition(ParserContext parserContext, BeanDefinition definition) {
        MutablePropertyValues propertyValues = parserContext.getContainingBeanDefinition().getPropertyValues();
        if (parserContext.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", (Object)definition);
        } else if (parserContext.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
            propertyValues.addPropertyValue("enrichmentMessageProcessor", (Object)definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if (messageProcessors == null || messageProcessors.getValue() == null) {
                propertyValues.addPropertyValue("messageProcessors", (Object)new ManagedList());
            }
            List listMessageProcessors = (List)propertyValues.getPropertyValue("messageProcessors").getValue();
            listMessageProcessors.add(definition);
        }
    }

    protected void setNoRecurseOnDefinition(BeanDefinition definition) {
        definition.setAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE", (Object)Boolean.TRUE);
    }

    protected String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId((Element)element);
        if (StringUtils.isBlank((String)id)) {
            String parentId = SpringXMLUtils.getNameOrId((Element)((Element)element.getParentNode()));
            return "." + parentId + ":" + element.getLocalName();
        }
        return id;
    }

    protected List parseNestedProcessorAsList(Element element, ParserContext parserContext, Class factory) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)factory);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        parserContext.getRegistry().registerBeanDefinition(this.generateChildBeanName(element), (BeanDefinition)beanDefinition);
        element.setAttribute("name", this.generateChildBeanName(element));
        builder.setScope("singleton");
        List list = parserContext.getDelegate().parseListElement(element, (BeanDefinition)builder.getBeanDefinition());
        parserContext.getRegistry().removeBeanDefinition(this.generateChildBeanName(element));
        return list;
    }

    protected void parseNestedProcessorAsListAndSetProperty(Element element, String childElementName, ParserContext parserContext, Class factory, BeanDefinitionBuilder builder, String propertyName) {
        Element childDomElement = DomUtils.getChildElementByTagName((Element)element, (String)childElementName);
        if (childDomElement != null) {
            builder.addPropertyValue(propertyName, (Object)this.parseNestedProcessorAsList(childDomElement, parserContext, factory));
        }
    }

    protected void parseElementAttributes(Map<String, String> attributePropetyMap, Element element, BeanDefinitionBuilder builder) {
        for (String attributeName : attributePropetyMap.keySet()) {
            String propertyName = attributePropetyMap.get(attributeName);
            if (!this.hasAttribute(element, attributeName)) continue;
            String attributeValue = element.getAttribute(attributeName);
            builder.addPropertyValue(propertyName, this.buildAttributeValue(attributeName, attributeValue));
        }
    }

    protected Object buildAttributeValue(String attributeName, String attributeValue) {
        if (attributeName.endsWith("-ref")) {
            if (attributeValue.startsWith("#[")) {
                return attributeValue;
            }
            return new RuntimeBeanReference(attributeValue);
        }
        return attributeValue;
    }

    protected void parseChildElementByType(ParseableElement parseableElement, Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        if (parseableElement instanceof ChildElement) {
            this.parseChildElement((ChildElement)parseableElement, element, builder, parserContext);
        }
        if (parseableElement instanceof ListChildElement) {
            this.parseListChildElement((ListChildElement)parseableElement, element, builder);
        }
        if (parseableElement instanceof MapChildElement) {
            this.parseMapChildElement((MapChildElement)parseableElement, element, builder);
        }
        if (parseableElement instanceof NestedChildElement) {
            this.parseNestedChildelement((NestedChildElement)parseableElement, element, builder, parserContext);
        }
    }

    protected void parseChildElement(ChildElement childElement, Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        BeanDefinitionBuilder childElementBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)childElement.getElementClass().getName());
        Element domChildElement = DomUtils.getChildElementByTagName((Element)element, (String)childElement.getElementName());
        if (domChildElement != null) {
            this.parseElementAttributes(childElement.getAttributePropertyMap(), domChildElement, childElementBuilder);
            for (String elementName : childElement.getChildElements().keySet()) {
                ParseableElement parseableElement = childElement.getChildElements().get(elementName);
                this.parseChildElementByType(parseableElement, domChildElement, childElementBuilder, parserContext);
            }
            builder.addPropertyValue(childElement.getElementPropertyName(), (Object)childElementBuilder.getBeanDefinition());
        }
    }

    protected void parseListChildElement(final ListChildElement listChildElement, Element element, BeanDefinitionBuilder builder) {
        this.parseListAndSetProperty(element, builder, listChildElement.getElementPropertyName(), listChildElement.getElementName(), listChildElement.getItemName(), new ParseDelegate<BeanDefinition>(){

            @Override
            public BeanDefinition parse(Element element) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)listChildElement.getItemClass());
                AbstractDefinitionParser.this.parseElementAttributes(listChildElement.getItemAttributePropertyMap(), element, builder);
                return builder.getBeanDefinition();
            }
        });
    }

    protected void parseMapChildElement(MapChildElement mapChildElement, Element element, BeanDefinitionBuilder builder) {
        this.parseMapAndSetProperty(element, builder, mapChildElement.getElementPropertyName(), mapChildElement.getElementName(), mapChildElement.getItemName(), new ParseDelegate<String>(){

            @Override
            public String parse(Element element) {
                return element.getTextContent();
            }
        });
    }

    protected void parseNestedChildelement(NestedChildElement nestedChildElement, Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String childElementName = nestedChildElement.getElementName();
        String propertyName = nestedChildElement.getElementPropertyName();
        this.parseNestedProcessorAsListAndSetProperty(element, childElementName, parserContext, nestedChildElement.getElementClass(), builder, propertyName);
    }

    public static interface ParseDelegate<T> {
        public T parse(Element var1);
    }
}

