/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.api.spring.config.parsers.model;


import static com.google.common.base.Preconditions.checkArgument;
import static org.apache.commons.lang.StringUtils.isNotBlank;


public class MapChildElement implements ParseableElement {

    private String elementName;
    private String elementPropertyName;

    private String itemName;

    public static class MapChildElementBuilder {
        protected String elementName;
        protected String elementPropertyName;

        protected String itemName;

        public MapChildElementBuilder(String elementName, String elementPropertyName) {
            checkArgument(isNotBlank(elementName), "The element name must not be null nor empty.");
            checkArgument(isNotBlank(elementPropertyName), "The element  property name must not be null nor empty.");

            this.elementName = elementName;
            this.elementPropertyName = elementPropertyName;
        }

        public MapChildElementBuilder withItemName(String itemName) {
            checkArgument(isNotBlank(itemName), "The item name must not be null nor empty.");
            this.itemName = itemName;
            return this;
        }

        public MapChildElement build() {
            checkArgument(isNotBlank(itemName), "Build Fail. The item name must not be null.");

            MapChildElement listChildElement = new MapChildElement();
            listChildElement.elementName = this.elementName;
            listChildElement.elementPropertyName = this.elementPropertyName;
            listChildElement.itemName = this.itemName;

            return listChildElement;
        }
    }


    public String getElementName() {
        return elementName;
    }

    public String getElementPropertyName() {
        return elementPropertyName;
    }

    public String getItemName() {
        return itemName;
    }
}


