/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.api.spring.config.parsers.model;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.api.spring.config.parsers.model.ParseableElement;

public class ListChildElement
implements ParseableElement {
    private String elementName;
    private String elementPropertyName;
    private Class itemClass;
    private String itemName;
    private Map<String, String> itemAttributePropertyMap = new HashMap<String, String>();

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getElementPropertyName() {
        return this.elementPropertyName;
    }

    public Class getItemClass() {
        return this.itemClass;
    }

    public String getItemName() {
        return this.itemName;
    }

    public Map<String, String> getItemAttributePropertyMap() {
        return this.itemAttributePropertyMap;
    }

    public static class ListChildElementBuilder {
        protected String elementName;
        protected String elementPropertyName;
        protected Class itemClass;
        protected String itemName;
        protected Map<String, String> itemAttributePropertyMap;

        public ListChildElementBuilder(String elementName, String elementPropertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementName), (Object)"The element name must not be null nor empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)elementPropertyName), (Object)"The element  property name must not be null nor empty.");
            this.elementName = elementName;
            this.elementPropertyName = elementPropertyName;
            this.itemAttributePropertyMap = new HashMap<String, String>();
        }

        public ListChildElementBuilder withItemClass(Class itemClass) {
            Preconditions.checkNotNull((Object)itemClass, (Object)"The item class class must not be null.");
            this.itemClass = itemClass;
            return this;
        }

        public ListChildElementBuilder withItemName(String itemName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)itemName), (Object)"The item name must not be null nor empty.");
            this.itemName = itemName;
            return this;
        }

        public ListChildElementBuilder withItemAttribute(String attributeName, String propertyName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)attributeName), (Object)"The attribute name must not be null nor empty.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)propertyName), (Object)"The property name must not be null nor empty.");
            this.itemAttributePropertyMap.put(attributeName, propertyName);
            return this;
        }

        public ListChildElement build() {
            Preconditions.checkNotNull((Object)this.itemClass, (Object)"Build Fail. The item class must not be null.");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.itemName), (Object)"Build Fail. The item name must not be null.");
            ListChildElement listChildElement = new ListChildElement();
            listChildElement.elementName = this.elementName;
            listChildElement.elementPropertyName = this.elementPropertyName;
            listChildElement.itemClass = this.itemClass;
            listChildElement.itemName = this.itemName;
            listChildElement.itemAttributePropertyMap.putAll(this.itemAttributePropertyMap);
            return listChildElement;
        }
    }
}

