/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.wrapped.transformers;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.util.TemplateParser;

import java.lang.reflect.Type;

/**
 * This class is a bridge to provide access to ExpressionEvaluatorSupport functionality
 */
public class ExpressionEvaluatorTransformer extends ExpressionEvaluatorSupport {

    public Object evaluateAndTransform(MuleContext muleContext, MuleEvent event, Type expectedType, String expectedMimeType, Object source) throws TransformerException, TransformerMessagingException {
        return super.evaluateAndTransform(muleContext, event, expectedType, expectedMimeType, source);
    }

    public Object evaluate(MuleContext muleContext, MuleEvent muleEvent, Object source) {
        return this.evaluate(TemplateParser.createMuleStyleParser().getStyle(), muleContext.getExpressionManager(), muleEvent.getMessage(), source);

    }
}
